/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.SleepingParticleMessage;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAISleep
extends EntityAIBase {
    private static final int TICK_INTERVAL = 30;
    private static final int CHANCE = 33;
    private static final DamageSource CLEANUP_DAMAGE = new DamageSource("CleanUpTask");
    private static final int MAX_BED_TICKS = 10;
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private boolean wokeUp = true;
    private int tickTimer = 0;
    private int bedTicks = 0;

    public EntityAISleep(EntityCitizen citizen) {
        this.func_75248_a(1);
        this.citizen = citizen;
    }

    public boolean func_75250_a() {
        return this.citizen.getDesiredActivity() == DesiredActivity.SLEEP || !this.wokeUp;
    }

    public boolean func_75253_b() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return true;
        }
        this.citizen.getCitizenSleepHandler().onWakeUp();
        if (this.usedBed != null) {
            IBlockState state = this.citizen.field_70170_p.func_180495_p(this.usedBed);
            if (state.func_177230_c() == Blocks.field_150324_C) {
                IBlockState headState = this.citizen.field_70170_p.func_180495_p(this.usedBed);
                this.citizen.field_70170_p.func_180501_a(this.usedBed, headState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
                BlockPos feetPos = this.usedBed.func_177972_a(((EnumFacing)headState.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
                IBlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
                if (feetState.func_177230_c() == Blocks.field_150324_C) {
                    this.citizen.field_70170_p.func_180501_a(feetPos, feetState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
            this.usedBed = null;
        }
        this.wokeUp = true;
        this.bedTicks = 0;
        return false;
    }

    public void func_75249_e() {
        this.citizen.getCitizenStatusHandler().setStatus(Status.SLEEPING);
    }

    public void func_75246_d() {
        ++this.tickTimer;
        if (this.tickTimer % 30 != 0) {
            return;
        }
        this.tickTimer = 0;
        if (!this.citizen.getCitizenColonyHandler().isAtHome()) {
            this.goHome();
            return;
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep() || this.bedTicks < 10) {
            this.findBedAndTryToSleep();
        } else {
            this.sleep();
        }
    }

    private void findBedAndTryToSleep() {
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        this.wokeUp = false;
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony != null && colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf()) != null) {
            if (this.usedBed == null) {
                IBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf());
                if (hut instanceof BuildingHome) {
                    for (BlockPos pos : ((BuildingHome)hut).getBedList()) {
                        World world = this.citizen.field_70170_p;
                        IBlockState state = world.func_180495_p(pos);
                        if ((state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos)).func_177230_c() != Blocks.field_150324_C || ((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD) || !world.func_175623_d(pos.func_177984_a())) continue;
                        this.usedBed = pos;
                        this.citizen.field_70170_p.func_180501_a(pos, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true)), 3);
                        BlockPos feetPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d());
                        IBlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
                        if (feetState.func_177230_c() == Blocks.field_150324_C) {
                            this.citizen.field_70170_p.func_180501_a(feetPos, feetState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        return;
                    }
                }
                this.usedBed = this.citizen.func_180486_cf();
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.bedTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
                    this.usedBed = null;
                }
            }
        }
    }

    private void sleep() {
        MineColonies.getNetwork().sendToAllTracking((IMessage)new SleepingParticleMessage(this.citizen.field_70165_t, this.citizen.field_70163_u + 1.0, this.citizen.field_70161_v), (Entity)this.citizen);
    }

    private void goHome() {
        BlockPos pos = this.citizen.func_180486_cf();
        if (pos == null || pos.equals((Object)BlockPos.field_177992_a)) {
            if (this.citizen.getCitizenColonyHandler().getColony() == null) {
                this.citizen.func_70645_a(CLEANUP_DAMAGE);
            } else {
                this.citizen.isWorkerAtSiteWithMove(this.citizen.getCitizenColonyHandler().getColony().getCenter(), 2);
            }
            return;
        }
        this.citizen.isWorkerAtSiteWithMove(pos, 2);
        int chance = this.citizen.getRandom().nextInt(33);
        if (chance <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWithChance(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.func_180425_c(), this.citizen.getCitizenJobHandler().getColonyJob().getBedTimeSound(), 1);
        }
    }
}

