/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.util.CompatibilityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIGateInteract
extends EntityAIBase {
    private static final int HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double MIN_DISTANCE = 2.25;
    protected EntityLiving theEntity;
    protected BlockPos gatePosition = BlockPos.field_177992_a;
    @Nullable
    protected BlockFenceGate gateBlock;
    private boolean hasStoppedFenceInteraction;
    private double entityPositionX;
    private double entityPositionZ;

    public EntityAIGateInteract(@NotNull EntityLiving entityIn) {
        this.theEntity = entityIn;
        if (!(entityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    public boolean func_75250_a() {
        return this.theEntity.field_70123_F && this.checkPath();
    }

    private boolean checkPath() {
        PathNavigateGround pathnavigateground = (PathNavigateGround)this.theEntity.func_70661_as();
        Path path = pathnavigateground.func_75505_d();
        return path != null && !path.func_75879_b() && pathnavigateground.func_179686_g() && this.checkFenceGate(path);
    }

    private boolean checkFenceGate(@NotNull Path path) {
        int maxLengthToCheck = Math.min(path.func_75873_e() + 2, path.func_75874_d());
        for (int i = 0; i < maxLengthToCheck; ++i) {
            PathPoint pathpoint = path.func_75877_a(i);
            for (int level = 0; level < 2; ++level) {
                this.gatePosition = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b + level, pathpoint.field_75838_c);
                if (!(this.theEntity.func_70092_e((double)this.gatePosition.func_177958_n(), this.theEntity.field_70163_u, (double)this.gatePosition.func_177952_p()) <= 2.25)) continue;
                this.gateBlock = this.getBlockFence(this.gatePosition);
                if (this.gateBlock == null) continue;
                return true;
            }
        }
        this.gatePosition = new BlockPos((Entity)this.theEntity).func_177984_a();
        this.gateBlock = this.getBlockFence(this.gatePosition);
        return this.gateBlock != null;
    }

    private BlockFenceGate getBlockFence(@NotNull BlockPos pos) {
        IBlockState blockState = CompatibilityUtils.getWorldFromEntity((Entity)this.theEntity).func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!(block instanceof BlockFenceGate) || blockState.func_185904_a() != Material.field_151575_d) {
            block = CompatibilityUtils.getWorldFromEntity((Entity)this.theEntity).func_180495_p(this.theEntity.func_180425_c()).func_177230_c();
            this.gatePosition = this.theEntity.func_180425_c();
        }
        return block instanceof BlockFenceGate && blockState.func_185904_a() == Material.field_151575_d ? (BlockFenceGate)block : null;
    }

    public boolean func_75253_b() {
        return !this.hasStoppedFenceInteraction;
    }

    public void func_75249_e() {
        this.hasStoppedFenceInteraction = false;
        this.entityPositionX = (double)this.gatePosition.func_177958_n() + 0.5 - this.theEntity.field_70165_t;
        this.entityPositionZ = (double)this.gatePosition.func_177952_p() + 0.5 - this.theEntity.field_70161_v;
    }

    public void func_75246_d() {
        double entityDistZ;
        double entityDistX = (double)this.gatePosition.func_177958_n() + 0.5 - this.theEntity.field_70165_t;
        double totalDist = this.entityPositionX * entityDistX + this.entityPositionZ * (entityDistZ = (double)this.gatePosition.func_177952_p() + 0.5 - this.theEntity.field_70161_v);
        if (totalDist < 0.0) {
            this.hasStoppedFenceInteraction = true;
        }
    }
}

