/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkShepherd
extends AbstractEntityAIHerder<JobShepherd, EntitySheep> {
    protected static final double EXP_PER_SHEEP = 5.0;
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    private static final int HUNDRED_PERCENT_CHANCE = 100;
    private static final int NUMBER_OF_DYE_POSSIBILITIES = 15;

    public EntityAIWorkShepherd(@NotNull JobShepherd job) {
        super(job);
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getDexterity() + this.worker.getCitizenData().getStrength());
        super.registerTargets(new AITarget((IAIState)AIWorkerState.SHEPHERD_SHEAR, this::shearSheep, 20));
    }

    @Override
    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        List<ToolType> toolsNeeded = super.getExtraToolsNeeded();
        toolsNeeded.add(ToolType.SHEARS);
        return toolsNeeded;
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingShepherd.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack(Items.field_151015_O);
        stack.func_190920_e(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        ArrayList animals = new ArrayList(this.searchForAnimals());
        EntitySheep shearingSheep = animals.stream().filter(sheepie -> !sheepie.func_70892_o() && !sheepie.func_70631_g_()).findFirst().orElse(null);
        if (result.equals(AIWorkerState.START_WORKING) && shearingSheep != null) {
            return AIWorkerState.SHEPHERD_SHEAR;
        }
        return result;
    }

    @Override
    public Class<EntitySheep> getAnimalClass() {
        return EntitySheep.class;
    }

    private IAIState shearSheep() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.shepherd.shearing", new Object[0])});
        List sheeps = this.searchForAnimals();
        if (sheeps.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(EnumHand.MAIN_HAND, ToolType.SHEARS)) {
            return AIWorkerState.PREPARING;
        }
        EntitySheep sheep = sheeps.stream().filter(sheepie -> !sheepie.func_70892_o()).findFirst().orElse(null);
        if (this.worker.func_184614_ca() != null && sheep != null) {
            if (this.walkingToAnimal((EntityAnimal)sheep)) {
                return this.getState();
            }
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            List items = sheep.onSheared(this.worker.func_184614_ca(), (IBlockAccess)this.worker.func_130014_f_(), this.worker.func_180425_c(), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.worker.func_184614_ca()));
            this.dyeSheepChance(sheep);
            this.worker.func_184614_ca().func_77972_a(1, (EntityLivingBase)this.worker);
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            for (ItemStack item : items) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            }
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    private void dyeSheepChance(EntitySheep sheep) {
        if (this.worker.getCitizenColonyHandler().getWorkBuilding() != null && ((BuildingShepherd)this.worker.getCitizenColonyHandler().getWorkBuilding()).isDyeSheeps()) {
            int chanceToDye = this.worker.getCitizenColonyHandler().getWorkBuilding().getBuildingLevel();
            int rand = this.world.field_73012_v.nextInt(100);
            if (rand <= chanceToDye) {
                int dyeInt = this.world.field_73012_v.nextInt(15);
                sheep.func_175512_b(EnumDyeColor.func_176764_b((int)dyeInt));
            }
        }
    }
}

