/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.AbstractScarescrowTileEntity;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteractionResponseHandler;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.network.messages.CompostParticleMessage;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int totalDis;
    private int dist;
    private boolean horizontal;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 10), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget((IAIState)AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        BuildingFarmer building = this.getWorkBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIWorkerState.PREPARING;
        }
        building.syncWithColony(this.world);
        if (building.getFarmerFields().size() < this.getWorkBuilding().getBuildingLevel() && !building.assignManually()) {
            this.searchAndAddFields();
        }
        if ((amountOfCompostInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), this::isCompost)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isCompost)) <= 0) {
            if (!((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack(ModItems.compost));
                compostAbleItems.add(new ItemStack(Items.field_151100_aR, 1, 15));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer"));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = this::isCompost;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (building.hasNoFields()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("entity.farmer.noFreeFields", new Object[0]), ChatPriority.BLOCKING));
            }
            this.worker.getCitizenData().getCitizenHappinessHandler().setNoFieldsToFarm();
            return AIWorkerState.PREPARING;
        }
        if (building.getCurrentField() == null && building.getFieldToWorkOn(this.world) == null) {
            building.resetFields();
            return AIWorkerState.IDLE;
        }
        BlockPos currentField = building.getCurrentField();
        TileEntity entity = this.world.func_175625_s(currentField);
        if (entity instanceof TileEntityScarecrow && ((TileEntityScarecrow)entity).needsWork()) {
            if (((TileEntityScarecrow)entity).getFieldStage() == ScarecrowFieldStage.PLANTED && this.checkIfShouldExecute((TileEntityScarecrow)entity, this::shouldHarvest)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (((TileEntityScarecrow)entity).getFieldStage() == ScarecrowFieldStage.HOED) {
                return this.canGoPlanting((TileEntityScarecrow)entity, building);
            }
            if (((TileEntityScarecrow)entity).getFieldStage() == ScarecrowFieldStage.EMPTY && this.checkIfShouldExecute((TileEntityScarecrow)entity, pos -> this.shouldHoe((BlockPos)pos, (TileEntityScarecrow)entity))) {
                return AIWorkerState.FARMER_HOE;
            }
            ((TileEntityScarecrow)entity).nextState();
        } else {
            this.getWorkBuilding().setCurrentField(null);
        }
        return AIWorkerState.PREPARING;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ModItems.compost) {
            return true;
        }
        if (itemStack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor enumdyecolor = EnumDyeColor.func_176766_a((int)itemStack.func_77960_j());
            return enumdyecolor == EnumDyeColor.WHITE;
        }
        return false;
    }

    public BuildingFarmer getWorkBuilding() {
        return this.getOwnBuilding(BuildingFarmer.class);
    }

    private void searchAndAddFields() {
        AbstractScarescrowTileEntity newField;
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony != null && (newField = colony.getBuildingManager().getFreeField(this.worker.getCitizenData().getId(), this.world)) != null && this.getWorkBuilding() != null) {
            newField.setOwner(this.worker.getCitizenData().getId());
            newField.setTaken(true);
            newField.func_70296_d();
            this.getWorkBuilding().addFarmerFields(newField.getPosition());
        }
    }

    private boolean checkIfShouldExecute(@NotNull TileEntityScarecrow field, @NotNull Predicate<BlockPos> predicate) {
        if (this.workingOffset == null) {
            this.handleOffset(field);
        }
        BlockPos position = field.func_174877_v().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        while (!predicate.test(position)) {
            if (!this.handleOffset(field)) {
                return false;
            }
            position = field.func_174877_v().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        }
        return true;
    }

    private IAIState canGoPlanting(@NotNull TileEntityScarecrow currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteractionResponseHandler((ITextComponent)new TranslationTextComponent("entity.farmer.noSeedSet", currentField.func_174877_v()), ChatPriority.BLOCKING, (ITextComponent)new TranslationTextComponent("entity.farmer.noSeedSet", new Object[0]), currentField.func_174877_v()));
            buildingFarmer.setCurrentField(null);
            this.worker.getCitizenData().getCitizenHappinessHandler().setNoFieldForFarmerModifier(currentField.func_174877_v(), false);
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().getCitizenHappinessHandler().setNoFieldForFarmerModifier(currentField.func_174877_v(), true);
        ItemStack seeds = currentField.getSeed().func_77946_l();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.func_77973_b(), seeds.func_77952_i());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.func_190920_e(seeds.func_77976_d());
        this.checkIfRequestForItemExistOrCreateAsynch(seeds);
        currentField.nextState();
        return AIWorkerState.PREPARING;
    }

    private boolean shouldHoe(@NotNull BlockPos position, @NotNull TileEntityScarecrow field) {
        return !field.isNoPartOfField(this.world, position) && !BlockUtils.isBlockSeed(this.world, position.func_177984_a()) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockScarecrow) && (this.world.func_180495_p(position).func_177230_c() instanceof BlockDirt || this.world.func_180495_p(position).func_177230_c() instanceof BlockGrass);
    }

    private boolean handleOffset(@NotNull TileEntityScarecrow field) {
        if (this.workingOffset == null) {
            this.workingOffset = new BlockPos(0, 0, 0);
            this.totalDis = 1;
            this.dist = 0;
            this.horizontal = true;
        } else {
            if (this.workingOffset.func_177952_p() >= field.getWidthPlusZ() && this.workingOffset.func_177958_n() <= -field.getLengthMinusX()) {
                this.workingOffset = null;
                return false;
            }
            if (this.totalDis == this.dist) {
                this.horizontal = !this.horizontal;
                this.dist = 0;
                if (this.horizontal) {
                    ++this.totalDis;
                }
            }
            this.workingOffset = this.horizontal ? new BlockPos((double)this.workingOffset.func_177958_n(), 0.0, (double)this.workingOffset.func_177952_p() - Math.pow(-1.0, this.totalDis)) : new BlockPos((double)this.workingOffset.func_177958_n() - Math.pow(-1.0, this.totalDis), 0.0, (double)this.workingOffset.func_177952_p());
            ++this.dist;
        }
        return true;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    private IAIState workAtField() {
        BuildingFarmer buildingFarmer = this.getWorkBuilding();
        if (buildingFarmer == null || this.checkForToolOrWeapon(ToolType.HOE) || buildingFarmer.getCurrentField() == null) {
            return AIWorkerState.PREPARING;
        }
        BlockPos field = buildingFarmer.getCurrentField();
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof TileEntityScarecrow) {
            TileEntityScarecrow scarecrow = (TileEntityScarecrow)entity;
            if (this.workingOffset != null) {
                if (scarecrow.getOwnerId() != this.worker.getCitizenId()) {
                    buildingFarmer.freeField(buildingFarmer.getCurrentField());
                    buildingFarmer.setCurrentField(null);
                    return this.getState();
                }
                BlockPos position = field.func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
                if (this.workingOffset.func_177958_n() <= scarecrow.getLengthPlusX() && this.workingOffset.func_177952_p() <= scarecrow.getWidthPlusZ() && this.workingOffset.func_177958_n() >= -scarecrow.getLengthMinusX() && this.workingOffset.func_177952_p() >= -scarecrow.getWidthMinusZ()) {
                    if (this.walkToBlock(position.func_177984_a())) {
                        return this.getState();
                    }
                    switch ((AIWorkerState)this.getState()) {
                        case FARMER_HOE: {
                            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.hoeing", new Object[0])});
                            if (this.hoeIfAble(position, scarecrow)) break;
                            return this.getState();
                        }
                        case FARMER_PLANT: {
                            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.planting", new Object[0])});
                            if (this.tryToPlant(scarecrow, position)) break;
                            return AIWorkerState.PREPARING;
                        }
                        case FARMER_HARVEST: {
                            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.harvesting", new Object[0])});
                            if (this.harvestIfAble(position)) break;
                            return this.getState();
                        }
                        default: {
                            return AIWorkerState.PREPARING;
                        }
                    }
                    this.prevPos = position;
                }
                this.setDelay(this.getLevelDelay());
            }
            if (!this.handleOffset(scarecrow)) {
                this.shouldDumpInventory = true;
                scarecrow.nextState();
                this.prevPos = null;
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, TileEntityScarecrow field) {
        if (this.shouldHoe(position, field) && !this.checkForToolOrWeapon(ToolType.HOE)) {
            if (this.mineBlock(position.func_177984_a())) {
                this.equipHoe();
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean harvestIfAble(BlockPos position) {
        if (this.shouldHarvest(position)) {
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            if (Compatibility.isPamsInstalled()) {
                this.harvestCrop(position.func_177984_a());
                return true;
            }
            return this.mineBlock(position.func_177984_a());
        }
        return true;
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.worker.getCitizenExperienceHandler().getLevel() * 1.0);
    }

    private boolean tryToPlant(TileEntityScarecrow field, BlockPos position) {
        return !this.shouldPlant(position, field) || this.plantCrop(field.getSeed(), position);
    }

    private void equipHoe() {
        this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, this.getHoeSlot());
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull TileEntityScarecrow field) {
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockCrops) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockStem) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockScarecrow) && this.world.func_180495_p(position).func_177230_c() == Blocks.field_150458_ak;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.func_77973_b(), item.func_77952_i());
        if (slot == -1) {
            return false;
        }
        IPlantable seed = (IPlantable)item.func_77973_b();
        if (!(seed != Items.field_151081_bc && seed != Items.field_151080_bb || this.prevPos == null || this.world.func_175623_d(this.prevPos.func_177984_a()))) {
            return true;
        }
        this.world.func_175656_a(position.func_177984_a(), seed.getPlant((IBlockAccess)this.world, position));
        this.worker.decreaseSaturationForContinuousAction();
        new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
        return true;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        IBlockState state = this.world.func_180495_p(position.func_177984_a());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150423_aK || block == Blocks.field_150440_ba) {
            return true;
        }
        if (this.isCrop(block)) {
            BlockCrops crop = (BlockCrops)block;
            if (crop.func_185525_y(state)) {
                return true;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return false;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isCompost)) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new CompostParticleMessage(position.func_177984_a()), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 16.0));
                crop.func_176487_g(this.world, position.func_177984_a(), state);
                state = this.world.func_180495_p(position.func_177984_a());
                block = state.func_177230_c();
                if (this.isCrop(block)) {
                    crop = (BlockCrops)block;
                }
            }
            return crop.func_185525_y(state);
        }
        return false;
    }

    public boolean isCrop(Block block) {
        return block instanceof IGrowable && block instanceof BlockCrops;
    }

    private void harvestCrop(@NotNull BlockPos pos) {
        ItemStack tool = this.worker.func_184614_ca();
        int fortune = ItemStackUtils.getFortuneOf(tool);
        IBlockState state = this.world.func_180495_p(pos);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.world, pos, state, fortune);
        for (ItemStack item : drops) {
            InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), item);
        }
        if (state.func_177230_c() instanceof BlockCrops) {
            BlockCrops crops = (BlockCrops)state.func_177230_c();
            this.world.func_175656_a(pos, crops.func_185528_e(0));
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenExperienceHandler().addExperience(0.05);
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.HOE, 0, this.getWorkBuilding().getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }

    @Override
    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType) {
        boolean needTool = super.checkForToolOrWeapon(toolType);
        this.worker.getCitizenData().getCitizenHappinessHandler().setNeedsATool(toolType, needTool);
        return needTool;
    }
}

