/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ShowColonyInfoCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "info";
    private static final String ID_TEXT = "\u00a72ID: \u00a7f";
    private static final String NAME_TEXT = "\u00a72 Name: \u00a7f";
    private static final String MAYOR_TEXT = "\u00a72Mayor: \u00a7f";
    private static final String COORDINATES_TEXT = "\u00a72Coordinates: \u00a7f";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String CITIZENS = "\u00a72Citizens: \u00a7f";
    private static final String NO_COLONY_FOR_PLAYER_FOUND_MESSAGE = "Colony with mayor %s not found.";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony not found.";
    private static final String NO_COLONY_WITH_ID_FOUND_MESSAGE = "Colony with ID %d not found.";
    private static final String LAST_CONTACT_TEXT = "Last contact with Owner or Officer: %d hours ago!";
    private static final String IS_DELETABLE = "If true this colony cannot be deleted: ";
    private static final String CANNOT_BE_RAIDED = "This colony is unable to be raided";

    public ShowColonyInfoCommand() {
        super(new String[0]);
    }

    public ShowColonyInfoCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        IColony iColony;
        IColony colony = actionMenuState.getColonyForArgument("colony");
        EntityPlayerMP player = null;
        if (null == colony && null != (player = actionMenuState.getPlayerForArgument("player")) && (iColony = IColonyManager.getInstance().getIColonyByOwner(sender.func_130014_f_(), (EntityPlayer)player)) != null) {
            if (!this.canPlayerUseCommand((EntityPlayer)player, AbstractSingleCommand.Commands.SHOWCOLONYINFO, iColony.getID())) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
                return;
            }
            colony = IColonyManager.getInstance().getColonyByWorld(iColony.getID(), (World)server.func_71218_a(sender.func_130014_f_().field_73011_w.getDimension()));
        }
        if (null == colony && sender instanceof EntityPlayer) {
            player = (EntityPlayer)sender;
            UUID mayorID = player.func_110124_au();
            IColony iColony2 = IColonyManager.getInstance().getIColonyByOwner(sender.func_130014_f_(), mayorID);
            if (iColony2 != null) {
                if (!this.canPlayerUseCommand((EntityPlayer)player, AbstractSingleCommand.Commands.SHOWCOLONYINFO, iColony2.getID())) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
                    return;
                }
                colony = IColonyManager.getInstance().getColonyByWorld(iColony2.getID(), (World)server.func_71218_a(sender.func_130014_f_().field_73011_w.getDimension()));
            }
        }
        if (colony == null) {
            if (null != player) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOR_PLAYER_FOUND_MESSAGE, player.func_70005_c_())));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE, new Object[0])));
            }
            return;
        }
        this.executeShared(server, sender, colony);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        GameProfile playerProfile;
        int colonyId = ShowColonyInfoCommand.getColonyIdFromArg(args, 0, -1);
        int dimensionId = ShowColonyInfoCommand.getDimensionIdFromArg(args, 0, sender instanceof EntityPlayer ? sender.func_130014_f_().field_73011_w.getDimension() : 0);
        IColony tempColony = IColonyManager.getInstance().getColonyByWorld(colonyId, (World)server.func_71218_a(dimensionId));
        if (colonyId == -1 && args.length >= 1 && (playerProfile = server.func_152358_ax().func_152655_a(args[0])) != null) {
            tempColony = IColonyManager.getInstance().getIColonyByOwner((World)server.func_71218_a(dimensionId), playerProfile.getId());
        }
        if (sender.func_174793_f() != null) {
            EntityPlayer player;
            UUID mayorID = sender.func_174793_f().func_110124_au();
            if (tempColony == null) {
                tempColony = IColonyManager.getInstance().getIColonyByOwner((World)server.func_71218_a(dimensionId), mayorID);
            }
            if (tempColony != null) {
                colonyId = tempColony.getID();
            }
            if (!this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.SHOWCOLONYINFO, colonyId)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
                return;
            }
        }
        if (tempColony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOR_PLAYER_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_WITH_ID_FOUND_MESSAGE, colonyId)));
            }
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(tempColony.getID(), (World)server.func_71218_a(dimensionId));
        if (colony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOR_PLAYER_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_WITH_ID_FOUND_MESSAGE, colonyId)));
            }
            return;
        }
        this.executeShared(server, sender, colony);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull IColony colony) throws CommandException {
        BlockPos position = colony.getCenter();
        sender.func_145747_a((ITextComponent)new TextComponentString(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()));
        String mayor = colony.getPermissions().getOwnerName();
        sender.func_145747_a((ITextComponent)new TextComponentString(MAYOR_TEXT + mayor));
        sender.func_145747_a((ITextComponent)new TextComponentString(CITIZENS + colony.getCitizenManager().getCitizens().size() + "/" + colony.getCitizenManager().getMaxCitizens()));
        sender.func_145747_a((ITextComponent)new TextComponentString(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(LAST_CONTACT_TEXT, colony.getLastContactInHours())));
        sender.func_145747_a((ITextComponent)new TextComponentString(IS_DELETABLE + !colony.canBeAutoDeleted()));
        if (!colony.getRaiderManager().canHaveRaiderEvents()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(CANNOT_BE_RAIDED));
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && ShowColonyInfoCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

