/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuild
extends WorkOrderBuildDecoration {
    private static final String TAG_UPGRADE_LEVEL = "upgradeLevel";
    private static final String TAG_UPGRADE_NAME = "upgrade";
    private static final double MAX_DISTANCE_SQ = 10000.0;
    private int upgradeLevel;
    private String upgradeName;

    public WorkOrderBuild() {
    }

    public WorkOrderBuild(@NotNull IBuilding building, int level) {
        this.buildingLocation = building.getID();
        this.upgradeLevel = level;
        this.upgradeName = building.getSchematicName() + level;
        this.buildingRotation = building.getRotation();
        this.isBuildingMirrored = building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored();
        this.cleared = level > 1;
        StructureName sn = new StructureName("schematics", building.getStyle(), this.getUpgradeName());
        if (building.getTileEntity() != null && !building.getTileEntity().getStyle().isEmpty()) {
            String previousStructureName = sn.toString();
            sn = new StructureName("schematics", building.getTileEntity().getStyle(), this.getUpgradeName());
            Log.getLogger().info("WorkOrderBuild at location " + this.buildingLocation + " is using " + sn + " instead of " + previousStructureName);
        }
        this.workOrderName = this.structureName = sn.toString();
        this.md5 = Structures.getMD5((String)this.structureName);
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound, IWorkManager manager) {
        super.readFromNBT(compound, manager);
        this.upgradeLevel = compound.func_74762_e(TAG_UPGRADE_LEVEL);
        this.upgradeName = compound.func_74779_i(TAG_UPGRADE_NAME);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a(TAG_UPGRADE_LEVEL, this.upgradeLevel);
        compound.func_74778_a(TAG_UPGRADE_NAME, this.upgradeName);
    }

    @Override
    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder) {
            return;
        }
        if (hasBuilder && sendMessage) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(this.upgradeLevel));
        }
        if (!hasBuilder) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageNoBuilder", new Object[0]);
        }
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        int builderLevel = citizen.getWorkBuilding().getBuildingLevel();
        return builderLevel >= this.upgradeLevel || builderLevel == 5 || citizen.getWorkBuilding() != null && citizen.getWorkBuilding().getID().equals((Object)this.buildingLocation) || WorkOrderBuild.isLocationTownhall(citizen.getColony(), this.buildingLocation) && citizen.getWorkBuilding().getPosition().func_177951_i((Vec3i)this.getBuildingLocation()) <= 10000.0;
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().noneMatch(building -> building instanceof BuildingBuilder && building.getMainCitizen() != null && building.getPosition().func_177951_i((Vec3i)this.getBuildingLocation()) <= 10000.0);
    }

    @Override
    public boolean isValid(@NotNull IColony colony) {
        return colony.getBuildingManager().getBuilding(this.buildingLocation) != null;
    }

    @Override
    protected String getValue() {
        return this.upgradeName;
    }

    @Override
    public int getRotation(World world) {
        return this.buildingRotation;
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        IBuilding building;
        if (!readingFromNbt && colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getBuildingLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getPosition(), building.getCorners(), colony.getWorld());
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.getBuildingLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    private static boolean isLocationTownhall(@NotNull IColony colony, BlockPos buildingLocation) {
        return colony.hasTownHall() && colony.getBuildingManager().getTownHall() != null && colony.getBuildingManager().getTownHall().getID().equals((Object)buildingLocation);
    }

    @Override
    public void onCompleted(IColony colony) {
        super.onCompleted(colony);
        BlockPos buildingLocation = this.getBuildingLocation();
        IBuilding building = colony.getBuildingManager().getBuilding(buildingLocation);
        colony.onBuildingUpgradeComplete(building, this.getUpgradeLevel());
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }
}

