/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class DeliveryRequestResolverFactory
implements IRequestResolverFactory<DeliveryRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends DeliveryRequestResolver> getFactoryOutputType() {
        return TypeToken.of(DeliveryRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public DeliveryRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new DeliveryRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull DeliveryRequestResolver deliveryRequestResolver) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(deliveryRequestResolver.getId()));
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(deliveryRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public DeliveryRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new DeliveryRequestResolver(location, token);
    }
}

