/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.sounds.BakerSounds;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.baker.EntityAIWorkBaker;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobBaker
extends AbstractJob {
    public JobBaker(ICitizenData entity) {
        super(entity);
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.baker;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.bakery";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.BAKER;
    }

    @Override
    @NotNull
    public AbstractAISkeleton<JobBaker> generateAI() {
        return new EntityAIWorkBaker(this);
    }

    @Override
    @Nullable
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.hostile : null;
        }
        return null;
    }
}

