/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteractionResponseHandler;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class RequestBasedInteractionResponseHandler
extends ServerCitizenInteractionResponseHandler {
    private static final String TOKEN_TAG = "token";
    private static final Tuple[] tuples = new Tuple[]{new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.okay", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.remindmelater", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.cancel", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.fulfill", new Object[0]), null)};
    private static final Tuple[] tuplesAsync = new Tuple[]{new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.okay", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.ignore", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.remindmelater", new Object[0]), null)};
    private IToken token = null;
    private BiPredicate<ICitizenData, IToken> validator;

    public RequestBasedInteractionResponseHandler(ITextComponent inquiry, IChatPriority priority, ITextComponent validator, IToken token) {
        super(inquiry, true, priority, null, validator, priority == ChatPriority.BLOCKING ? tuples : tuplesAsync);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(validator);
        this.token = token;
    }

    public RequestBasedInteractionResponseHandler(ITextComponent inquiry, IChatPriority priority, IToken token) {
        super(inquiry, true, priority, null, inquiry, tuples);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(inquiry);
        this.token = token;
    }

    public RequestBasedInteractionResponseHandler(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.token);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a(TOKEN_TAG, (NBTBase)StandardFactoryController.getInstance().serialize(this.token));
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(compoundNBT.func_74775_l(TOKEN_TAG));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClientResponseTriggered(ITextComponent response, World world, ICitizenDataView data, Window window) {
        if (response.equals((Object)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.fulfill", new Object[0]))) {
            IRequest<?> request;
            IColonyView colony = IColonyManager.getInstance().getColonyView(data.getColonyId(), world.field_73011_w.getDimension());
            if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
                WindowCitizen windowCitizen = new WindowCitizen(data);
                windowCitizen.open();
                windowCitizen.goToRequestList();
                WindowRequestDetail windowRequestDetail = new WindowRequestDetail(windowCitizen, request, data.getColonyId());
                windowRequestDetail.open();
                return false;
            }
        } else {
            return super.onClientResponseTriggered(response, world, data, window);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(ITextComponent response, World world, ICitizenData data) {
        super.onServerResponseTriggered(response, world, data);
        if (response.equals((Object)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.cancel", new Object[0])) && data.getColony() != null) {
            data.getColony().getRequestManager().updateRequestState(this.token, RequestState.CANCELLED);
        }
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.REQUEST.func_110623_a();
    }
}

