/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.babarianEvent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.colony.ColonyState;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.babarianEvent.BarbarianHorde;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateEventUtils;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityChiefBarbarian;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.jetbrains.annotations.NotNull;

public class BarbarianRaidEvent
implements IColonyRaidEvent {
    public static final ResourceLocation BABARIAN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "babarian_raid");
    public static int MAX_SPAWN_DEVIATION = 300;
    public static int MAX_RESPAWN_DEVIATION = 80;
    public static int MIN_CENTER_DISTANCE = 100;
    private BarbarianHorde horde;
    private Map<Entity, UUID> barbarians = new WeakHashMap<Entity, UUID>();
    private Map<Entity, UUID> archers = new WeakHashMap<Entity, UUID>();
    private Map<Entity, UUID> chiefs = new WeakHashMap<Entity, UUID>();
    private List<Tuple<ResourceLocation, BlockPos>> respawns = new ArrayList<Tuple<ResourceLocation, BlockPos>>();
    private IColony colony;
    private int id;
    private BlockPos spawnPoint;
    private EventStatus status = EventStatus.STARTING;
    private int daysToGo = 3;

    public BarbarianRaidEvent(IColony colony) {
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.addAll(this.archers.keySet());
        entities.addAll(this.chiefs.keySet());
        entities.addAll(this.barbarians.keySet());
        return entities;
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return BABARIAN_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityChiefBarbarian && this.chiefs.keySet().size() < this.horde.numberOfBosses) {
            this.chiefs.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityArcherBarbarian && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityBarbarian && this.barbarians.keySet().size() < this.horde.numberOfRaiders) {
            this.barbarians.put(entity, entity.func_110124_au());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.archers.containsKey(entity) && !this.chiefs.containsKey(entity) && !this.barbarians.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.archers.remove(entity);
        this.chiefs.remove(entity);
        this.barbarians.remove(entity);
        ResourceLocation entityID = EntityRegistry.getEntry(entity.getClass()).getRegistryName();
        this.respawns.add(new Tuple<ResourceLocation, BlockPos>(entityID, entity.func_180425_c()));
    }

    @Override
    public void onEntityDeath(EntityLiving entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity.field_70128_L) {
            Log.getLogger().warn("THROWS TANTRUM!");
        }
        if (entity instanceof EntityChiefBarbarian) {
            this.chiefs.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherBarbarian) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityBarbarian) {
            this.barbarians.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    @Override
    public void onStart() {
        BlockPos spawnPos = PirateEventUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_SPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10);
        if (spawnPos == null) {
            this.status = EventStatus.CANCELED;
            return;
        }
        this.status = EventStatus.PROGRESSING;
        RaiderMobUtils.spawn(ColonyConstants.BARBARIAN, this.horde.numberOfRaiders, spawnPos, this.colony.getWorld(), this.colony, this.id);
        RaiderMobUtils.spawn(ColonyConstants.CHIEF, this.horde.numberOfBosses, spawnPos, this.colony.getWorld(), this.colony, this.id);
        RaiderMobUtils.spawn(ColonyConstants.ARCHER, this.horde.numberOfArchers, spawnPos, this.colony.getWorld(), this.colony, this.id);
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "event.minecolonies.raidMessage" + this.horde.getMessageID(), this.colony.getName(), BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint));
    }

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        if (!this.respawns.isEmpty()) {
            for (Tuple<ResourceLocation, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = PirateEventUtils.getLoadedPositionTowardsCenter(entry.getSecond(), this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getFirst(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        if (this.chiefs.size() + this.archers.size() + this.barbarians.size() < this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers && (spawnPos = PirateEventUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10)) != null) {
            RaiderMobUtils.spawn(ColonyConstants.CHIEF, this.horde.numberOfBosses - this.chiefs.size(), spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(ColonyConstants.ARCHER, this.horde.numberOfArchers - this.archers.size(), spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(ColonyConstants.BARBARIAN, this.horde.numberOfRaiders - this.barbarians.size(), spawnPos, this.colony.getWorld(), this.colony, this.id);
        }
        if (this.colony.getRaiderManager().areSpiesEnabled()) {
            for (Entity entity : this.getEntities()) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 550));
            }
        }
    }

    @Override
    public void onFinish() {
        for (Entity entity : this.getEntities()) {
            entity.func_70106_y();
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo < 0) {
            this.status = EventStatus.DONE;
        }
    }

    public void setHorde(BarbarianHorde horde) {
        this.horde = horde;
    }

    private void sendHordeMessage() {
        int total = 0;
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            if (!(event instanceof BarbarianRaidEvent)) continue;
            total += ((BarbarianRaidEvent)event).horde.hordeSize;
        }
        if (total == 0) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.barbarians.killed", new Object[0]);
        } else if (total > 0 && total <= 5) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.barbarians.left", total);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("mc_event_id", this.id);
        BlockPosUtil.writeToNBT(compound, "spawnPos", this.spawnPoint);
        compound.func_74768_a("eventStatus", this.status.ordinal());
        compound.func_74768_a("pirateDaysLeft", this.daysToGo);
        this.horde.writeToNbt(compound);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("mc_event_id");
        this.setHorde(BarbarianHorde.loadFromNbt(compound));
        this.spawnPoint = BlockPosUtil.readFromNBT(compound, "spawnPos");
        this.status = EventStatus.values()[compound.func_74762_e("eventStatus")];
        this.daysToGo = compound.func_74762_e("pirateDaysLeft");
    }

    public static BarbarianRaidEvent loadFromNBT(IColony colony, NBTTagCompound compound) {
        BarbarianRaidEvent event = new BarbarianRaidEvent(colony);
        event.readFromNBT(compound);
        return event;
    }
}

