/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutCowboy;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.network.messages.CowboySetMilkCowsMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingCowboy
extends AbstractBuildingWorker {
    private static final String COWBOY = "Cowboy";
    private static final String NBT_MILK_COWS = "MILK_COWS";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean milkCows = true;

    public BuildingCowboy(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COWBOY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return COWBOY;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobCowboy(citizen);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.milkCows);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.cowboy;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.milkCows = compound.func_74767_n(NBT_MILK_COWS);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74757_a(NBT_MILK_COWS, this.milkCows);
        return compound;
    }

    public boolean isMilkingCows() {
        return this.milkCows;
    }

    public void setMilkCows(boolean milkCows) {
        this.milkCows = milkCows;
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean milkCows = true;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCowboy(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }

        public void setMilkCows(boolean milkCows) {
            MineColonies.getNetwork().sendToServer((IMessage)new CowboySetMilkCowsMessage(this, milkCows));
            this.milkCows = milkCows;
        }

        public boolean isMilkCows() {
            return this.milkCows;
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.milkCows = buf.readBoolean();
        }
    }
}

