/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.BlockBarracksTowerSubstitution;
import com.minecolonies.coremod.client.gui.WindowBarracksBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "Barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final String TAG_TOWERS = "towers";
    private final List<BlockPos> towers = new ArrayList<BlockPos>();
    public static int SPIES_GOLD_COST = 5;

    public BuildingBarracks(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(stack -> stack.func_77973_b() == Items.field_151043_k, new Tuple((Object)64, (Object)true));
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (BlockPos tower : this.towers) {
                world.func_175656_a(tower, Blocks.field_150350_a.func_176223_P());
            }
        }
        super.onDestroyed();
    }

    @Override
    public void registerBlockPosition(@NotNull IBlockState block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block.func_177230_c() == ModBlocks.blockBarracksTowerSubstitution || block.func_177230_c() == ModBlocks.blockHutBarracksTower) {
            IBuilding building;
            if (world.func_180495_p(pos).func_177230_c() != ModBlocks.blockHutBarracksTower) {
                world.func_175656_a(pos, ModBlocks.blockHutBarracksTower.func_176223_P().func_177226_a((IProperty)BlockBarracksTowerSubstitution.FACING, block.func_177229_b((IProperty)AbstractBlockHut.FACING)));
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityColonyBuilding) {
                    ((TileEntityColonyBuilding)tile).setStyle(this.getStyle());
                }
                this.getColony().getBuildingManager().addNewBuilding((TileEntityColonyBuilding)world.func_175625_s(pos), world);
            }
            if ((building = this.getColony().getBuildingManager().getBuilding(pos)) instanceof BuildingBarracksTower) {
                building.setStyle(this.getStyle());
                ((BuildingBarracksTower)building).addBarracks(this.getPosition());
                if (!this.towers.contains(pos)) {
                    this.towers.add(pos);
                }
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (colony.getWorld().field_72995_K) {
            return;
        }
        if (colony.getRaiderManager().isRaided()) {
            int amount;
            if (!colony.getRaiderManager().areSpiesEnabled() && (amount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.getTileEntity().getInventory(), Items.field_151043_k, 0)) >= SPIES_GOLD_COST) {
                InventoryUtils.removeStackFromItemHandler((IItemHandler)this.tileEntity.getInventory(), new ItemStack(Items.field_151043_k, SPIES_GOLD_COST));
                colony.getRaiderManager().setSpiesEnabled(true);
                colony.markDirty();
            }
        } else {
            colony.getRaiderManager().setSpiesEnabled(false);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        int sum = newLevel;
        for (BlockPos pos : this.towers) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
            if (building == null) continue;
            sum += building.getBuildingLevel();
        }
        return Math.max(1, sum / this.getMaxBuildingLevel());
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.barracks;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.towers.clear();
        this.towers.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_TOWERS, 10)).map(resultCompound -> BlockPosUtil.readFromNBT(resultCompound, "pos")).collect(Collectors.toList()));
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList towerTagList = this.towers.stream().map(pos -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "pos", pos)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a(TAG_TOWERS, (NBTBase)towerTagList);
        return compound;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

