/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.ColonyUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
extends AbstractBuildingContainer
implements IBuilding {
    public static final int MAX_BUILD_HEIGHT = 256;
    public static final int MIN_BUILD_HEIGHT = 1;
    @NotNull
    private IToken<?> rsDataStoreToken;
    private IRequester requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
    private boolean beingGathered = false;
    private boolean isBuilt = false;
    private String customName = "";

    protected AbstractBuilding(@NotNull IColony colony, BlockPos pos) {
        super(pos, colony);
        this.setupRsDataStore();
    }

    @Override
    @NotNull
    public String getCustomBuildingName() {
        return this.customName;
    }

    @Override
    public void onWakeUp() {
    }

    @Override
    public void onCleanUp(ICitizenData citizen) {
    }

    @Override
    public void onRestart(ICitizenData citizen) {
        citizen.setPaused(false);
    }

    @Override
    public void onPlacement() {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(this.colony.getWorld(), true, this.colony.getID(), this.getPosition(), this.colony.getDimension(), this.getClaimRadius(this.getBuildingLevel()));
        }
    }

    @Override
    public boolean isMatchingBlock(@NotNull Block block) {
        return this.getBuildingRegistryEntry().getBuildingBlock() == block;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.loadRequestSystemFromNBT(compound);
        if (compound.func_74764_b("isBuilt")) {
            this.isBuilt = compound.func_74767_n("isBuilt");
        } else if (this.getBuildingLevel() > 0) {
            this.isBuilt = true;
        }
        if (compound.func_74764_b("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74778_a("type", this.getBuildingRegistryEntry().getRegistryName().toString());
        this.writeRequestSystemToNBT(compound);
        compound.func_74757_a("isBuilt", this.isBuilt);
        compound.func_74778_a("customName", this.customName);
        return compound;
    }

    @Override
    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getCloseSubscribers());
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        AbstractTileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.func_180495_p(this.getPosition()).func_177230_c();
        if (tileEntityNew != null) {
            InventoryUtils.dropItemHandler((IItemHandler)tileEntityNew.getInventory(), world, tileEntityNew.getPosition().func_177958_n(), tileEntityNew.getPosition().func_177956_o(), tileEntityNew.getPosition().func_177952_p());
            world.func_175666_e(this.getPosition(), block);
        }
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(world, false, this.colony.getID(), this.getID(), this.colony.getDimension(), this.getClaimRadius(this.getBuildingLevel()));
        }
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
    }

    protected void requestWorkOrder(int level, BlockPos builder) {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        WorkOrderBuildBuilding workOrderBuildBuilding = new WorkOrderBuildBuilding(this, level);
        if (!this.canBeBuiltByBuilder(level) && !workOrderBuildBuilding.canBeResolved(this.colony, level)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(level));
            return;
        }
        if (workOrderBuildBuilding.tooFarFromAnyBuilder(this.colony, level) && builder.equals((Object)BlockPos.field_177992_a)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildersTooFar", new Object[0]);
            return;
        }
        if (this.getPosition().func_177956_o() + this.getHeight() >= 256) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildTooHigh", new Object[0]);
            return;
        }
        if (this.getPosition().func_177956_o() <= 1) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuildTooLow", new Object[0]);
            return;
        }
        if (!builder.equals((Object)BlockPos.field_177992_a)) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(builder);
            if (building instanceof AbstractBuildingStructureBuilder && (building.getBuildingLevel() >= level || this.canBeBuiltByBuilder(level))) {
                workOrderBuildBuilding.setClaimedBy(builder);
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(level));
                return;
            }
        }
        this.colony.getWorkManager().addWorkOrder(workOrderBuildBuilding, false);
        this.colony.getProgressManager().progressWorkOrderPlacement(workOrderBuildBuilding);
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.workOrderAdded", new Object[0]);
        this.markDirty();
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return false;
    }

    @Override
    public final void markDirty() {
        super.markDirty();
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    @Override
    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != 0;
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return o.getUpgradeLevel();
        }
        return 0;
    }

    @Override
    public void removeWorkOrder() {
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            BlockPos buildingPos = o.getClaimedBy();
            IBuilding building = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (building != null && building.getMainCitizen() != null) {
                building.cancelAllRequestsOfCitizen(building.getMainCitizen());
            }
            return;
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 3: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getBuildingRegistryEntry().getRegistryName().toString());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeBoolean(this.isPriorityStatic());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getStyle());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getSchematicName());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getCustomBuildingName());
        buf.writeInt(this.getRotation());
        buf.writeBoolean(this.isMirrored());
        buf.writeInt(this.getClaimRadius(this.getBuildingLevel()));
        NBTTagCompound requestSystemCompound = new NBTTagCompound();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        buf.writeInt(resolvers.size());
        for (IRequestResolver resolver : resolvers) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(resolver.getId()));
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(this.getId()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)requestSystemCompound);
    }

    @Override
    public boolean isBeingGathered() {
        return this.beingGathered;
    }

    @Override
    public void setCustomBuildingName(String name) {
        this.customName = name;
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public void setBeingGathered(boolean gathering) {
        this.beingGathered = gathering;
    }

    @Override
    public void requestUpgrade(EntityPlayer player, BlockPos builder) {
        if (this.getBuildingLevel() < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.getBuildingLevel() + 1, builder);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.worker.noUpgrade", new Object[0]));
        }
    }

    @Override
    public void requestRepair(BlockPos builder) {
        if (this.getBuildingLevel() > 0) {
            this.requestWorkOrder(this.getBuildingLevel(), builder);
        }
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public void deconstruct() {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> tuple = this.getCorners();
        for (int x = ((Integer)((Tuple)tuple.func_76341_a()).func_76341_a()).intValue(); x < (Integer)((Tuple)tuple.func_76341_a()).func_76340_b(); ++x) {
            for (int z = ((Integer)((Tuple)tuple.func_76340_b()).func_76341_a()).intValue(); z < (Integer)((Tuple)tuple.func_76340_b()).func_76340_b(); ++z) {
                for (int y = this.getPosition().func_177956_o() - 1; y < this.getPosition().func_177956_o() + this.getHeight(); ++y) {
                    this.getColony().getWorld().func_175655_b(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    @Override
    public AbstractTileEntityColonyBuilding getTileEntity() {
        if ((this.tileEntity == null || this.tileEntity.func_145837_r()) && this.colony != null && this.colony.getWorld() != null && this.getPosition() != null && this.colony.getWorld().func_180495_p(this.getPosition()) != Blocks.field_150350_a && this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c() instanceof AbstractBlockHut) {
            TileEntity te = this.getColony().getWorld().func_175625_s(this.getPosition());
            if (te instanceof TileEntityColonyBuilding) {
                this.tileEntity = (TileEntityColonyBuilding)te;
                if (this.tileEntity.getBuilding() == null) {
                    this.tileEntity.setColony(this.colony);
                    this.tileEntity.setBuilding(this);
                }
            } else {
                Log.getLogger().error("Somehow the wrong TileEntity is at the location where the building should be!");
                Log.getLogger().error("Trying to restore order!");
                TileEntityColonyBuilding tileEntityColonyBuilding = new TileEntityColonyBuilding(this.getBuildingRegistryEntry().getRegistryName());
                this.colony.getWorld().func_175690_a(this.getPosition(), (TileEntity)tileEntityColonyBuilding);
                this.tileEntity = tileEntityColonyBuilding;
            }
        }
        return this.tileEntity;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(this.colony.getWorld(), true, this.colony.getID(), this.getID(), this.colony.getDimension(), this.getClaimRadius(newLevel));
        }
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), this.colony.getWorld());
        this.colony.getProgressManager().progressBuildBuilding(this, this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof AbstractBuildingWorker).mapToInt(ISchematicProvider::getBuildingLevel).sum(), this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof BuildingHome).mapToInt(ISchematicProvider::getBuildingLevel).sum());
        WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(this, newLevel);
        Structure wrapper = new Structure(this.colony.getWorld(), workOrder.getStructureName(), new PlacementSettings());
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(this.getPosition(), this.colony.getWorld(), wrapper, workOrder.getRotation(this.colony.getWorld()), workOrder.isMirrored());
        this.setHeight(wrapper.getHeight());
        this.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        this.isBuilt = true;
        if (newLevel > this.getBuildingLevel()) {
            FireworkUtils.spawnFireworksAtAABBCorners(this.getTargetableArea(this.colony.getWorld()), this.colony.getWorld(), newLevel);
        }
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        for (Map.Entry<Predicate<ItemStack>, Tuple<Integer, Boolean>> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (inventory && !((Boolean)entry.getValue().func_76340_b()).booleanValue() || !entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            int toKeep = (Integer)entry.getValue().func_76341_a();
            int rest = stack.func_190916_E() - toKeep;
            if (kept != null) {
                if (kept.getAmount() >= toKeep) {
                    return stack.func_190916_E();
                }
                rest = kept.getAmount() + stack.func_190916_E() - toKeep;
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(kept);
            } else {
                ItemStorage newStorage = new ItemStorage(stack);
                newStorage.setAmount(ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(newStorage);
            }
            if (rest <= 0) {
                return 0;
            }
            return Math.min(rest, ItemStackUtils.getSize(stack));
        }
        return stack.func_190916_E();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        IRequestManager manager = this.colony.getRequestManager();
        toKeep.put(stack -> this.getOpenRequestsByCitizen().values().stream().anyMatch(list -> list.stream().filter(token -> manager.getRequestForToken((IToken<?>)token) != null).anyMatch(token -> manager.getRequestForToken((IToken<?>)token).getRequest() instanceof IDeliverable && ((IDeliverable)manager.getRequestForToken((IToken<?>)token).getRequest()).matches((ItemStack)stack))), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        return toKeep;
    }

    @Override
    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.getTileEntity() == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.getTileEntity(), stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept) != stack.func_190916_E());
    }

    protected void writeRequestSystemToNBT(NBTTagCompound compound) {
        compound.func_74782_a("DataStoreToken", (NBTBase)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    protected void setupRsDataStore() {
        this.rsDataStoreToken = this.colony.getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE).getId();
    }

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.requester = compound.func_74764_b("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        if (compound.func_74764_b("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    private Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.getDataStore().getOpenRequestsByRequestableType();
    }

    protected Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.getDataStore().getCompletedRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData citizenData, @NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        if (async) {
            citizenData.getJob().getAsyncRequests().add(requestToken);
        }
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(-1, requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    private void addRequestToMaps(@NotNull Integer citizenId, @NotNull IToken requestToken, @NotNull TypeToken requested) {
        if (!this.getOpenRequestsByRequestableType().containsKey(requested)) {
            this.getOpenRequestsByRequestableType().put(requested, new ArrayList());
        }
        this.getOpenRequestsByRequestableType().get(requested).add(requestToken);
        this.getCitizensByRequest().put(requestToken, citizenId);
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            this.getOpenRequestsByCitizen().put(citizenId, new ArrayList());
        }
        this.getOpenRequestsByCitizen().get(citizenId).add(requestToken);
    }

    @Override
    public boolean hasWorkerOpenRequests(@NotNull ICitizenData citizen) {
        return !this.getOpenRequests(citizen).isEmpty();
    }

    @Override
    public ImmutableList<IRequest> getOpenRequests(@NotNull ICitizenData data) {
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public boolean hasWorkerOpenRequestsFiltered(@NotNull ICitizenData citizen, @NotNull Predicate<IRequest> selectionPredicate) {
        return this.getOpenRequests(citizen).stream().anyMatch(selectionPredicate);
    }

    @Override
    public <R> boolean hasWorkerOpenRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenData, requestType).isEmpty();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    @Override
    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData data) {
        return !this.getCompletedRequests(data).isEmpty();
    }

    @Override
    public ImmutableList<IRequest> getCompletedRequests(@NotNull ICitizenData data) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getCompletedRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    @Override
    public void markRequestAsAccepted(@NotNull ICitizenData data, @NotNull IToken<?> token) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId()) || !this.getCompletedRequestsByCitizen().get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
        if (this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.getColony().getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    @Override
    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData data) {
        this.getOpenRequests(data).forEach(request -> {
            this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.CANCELLED);
            if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
                this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
                if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                    this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
                }
            }
            this.getCitizensByRequest().remove(request.getId());
        });
        this.getCompletedRequests(data).forEach(request -> this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED));
        this.getOpenRequestsByCitizen().remove(data.getId());
        this.getCompletedRequestsByCitizen().remove(data.getId());
        this.markDirty();
    }

    @Override
    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return;
        }
        Set<Integer> citizenIdsWithRequests = this.getOpenRequestsByCitizen().keySet();
        if (citizenIdsWithRequests.isEmpty()) {
            ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
            for (IRequestResolver resolver : resolvers) {
                IStandardRequestManager requestManager = (IStandardRequestManager)this.getColony().getRequestManager();
                List<IRequest<? extends IDeliverable>> deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
                IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList(deliverableRequests, stack);
                if (target == null) continue;
                this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
                return;
            }
            return;
        }
        for (int citizenId : citizenIdsWithRequests) {
            IRequest<? extends IDeliverable> target;
            ICitizenData data = this.getColony().getCitizenManager().getCitizen(citizenId);
            if (data == null || (target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(data, TypeConstants.DELIVERABLE), stack)) == null) continue;
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
            return;
        }
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    @Override
    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(citizenData, TypeConstants.DELIVERABLE), stack);
        if (target == null) {
            AbstractJobCrafter crafterJob;
            if (citizenData.getJob() instanceof AbstractJobCrafter && !(crafterJob = citizenData.getJob(AbstractJobCrafter.class)).getAssignedTasks().isEmpty()) {
                List<IToken<?>> assignedTasks = crafterJob.getAssignedTasks();
                IRequest deliverableChildRequest = assignedTasks.stream().map(this.getColony().getRequestManager()::getRequestForToken).map(IRequest::getChildren).flatMap(Collection::stream).map(this.getColony().getRequestManager()::getRequestForToken).filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).filter(iRequest -> ((IDeliverable)iRequest.getRequest()).matches(stack)).findFirst().map(iRequest -> iRequest).orElse(null);
                if (deliverableChildRequest != null) {
                    deliverableChildRequest.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
                    this.getColony().getRequestManager().overruleRequest((IToken<?>)deliverableChildRequest.getId(), stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        target.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
        this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
        return true;
    }

    private IRequest<? extends IDeliverable> getFirstOverullingRequestFromInputList(@NotNull Collection<IRequest<? extends IDeliverable>> queue, @NotNull ItemStack stack) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList validRequesterTokens = Lists.newArrayList();
        validRequesterTokens.add(this.getId());
        this.getResolvers().forEach(iRequestResolver -> validRequesterTokens.add(iRequestResolver.getId()));
        return queue.stream().filter(request -> validRequesterTokens.contains(request.getRequester().getId()) && ((IDeliverable)request.getRequest()).matches(stack)).findFirst().orElse(null);
    }

    private Collection<IRequest<? extends IDeliverable>> flattenDeliverableChildRequests(@NotNull IRequest<? extends IDeliverable> request) {
        if (!request.hasChildren()) {
            return ImmutableList.of();
        }
        return request.getChildren().stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).filter(request1 -> request1.getRequest() instanceof IDeliverable).map(request1 -> request1).collect(Collectors.toList());
    }

    @Override
    public IToken<?> getId() {
        return this.requester.getId();
    }

    @Override
    public final ImmutableCollection<IRequestResolver<?>> getResolvers() {
        IStandardRequestManager requestManager = (IStandardRequestManager)this.getColony().getRequestManager();
        if (!requestManager.getProviderHandler().getRegisteredResolvers(this).isEmpty()) {
            return ImmutableList.copyOf((Collection)requestManager.getProviderHandler().getRegisteredResolvers(this).stream().map(token -> requestManager.getResolverHandler().getResolver((IToken<?>)token)).collect(Collectors.toList()));
        }
        return this.createResolvers();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    @Override
    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.getRequester().getLocation();
    }

    @Override
    @NotNull
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
        this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
        if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
            this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
        }
        if (!this.getCompletedRequestsByCitizen().containsKey(citizenThatRequested)) {
            this.getCompletedRequestsByCitizen().put(citizenThatRequested, new ArrayList());
        }
        this.getCompletedRequestsByCitizen().get(citizenThatRequested).add((IToken<?>)request.getId());
        this.markDirty();
    }

    @Override
    @NotNull
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
        if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
            this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
            if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
            }
        }
        if (this.getColony().getCitizenManager().getCitizen(citizenThatRequested) != null) {
            this.getColony().getCitizenManager().getCitizen(citizenThatRequested).onRequestCancelled((IToken)request.getId());
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!this.getCitizensByRequest().containsKey(request.getId())) {
            return new TextComponentString("<UNKNOWN>");
        }
        Integer citizenData = this.getCitizensByRequest().get(request.getId());
        return new TextComponentString(this.getSchematicName() + " " + this.getColony().getCitizenManager().getCitizen(citizenData).getName());
    }

    @Override
    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken token) {
        if (!this.getCitizensByRequest().containsKey(token) || this.getColony() == null) {
            return Optional.empty();
        }
        int citizenID = this.getCitizensByRequest().get(token);
        if (this.getColony().getCitizenManager().getCitizen(citizenID) == null) {
            return Optional.empty();
        }
        return Optional.of(this.getColony().getCitizenManager().getCitizen(citizenID));
    }

    @Override
    public boolean requiresCompleteRequestFulfillment() {
        return true;
    }
}

