/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowHutFarmer
extends AbstractWindowWorkerBuilding<BuildingFarmer.View> {
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/windowhutfarmer.xml";
    private static final String PAGE_FIELDS = "pageFields";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_WORKER = "worker";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private ScrollingList fieldList;
    private final WorldClient world;

    public WindowHutFarmer(BuildingFarmer.View building) {
        super(building, "minecolonies:gui/windowhutfarmer.xml");
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane(button);
        BlockPos field = this.fields.get(row);
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof TileEntityScarecrow) {
            if (button.getLabel().equals(RED_X)) {
                button.setLabel(APPROVE);
                ((BuildingFarmer.View)this.building).changeFields(field, false, (TileEntityScarecrow)entity);
            } else {
                button.setLabel(RED_X);
                ((BuildingFarmer.View)this.building).changeFields(field, true, (TileEntityScarecrow)entity);
            }
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
        }
    }

    private void pullLevelsFromHut() {
        this.fields = ((BuildingFarmer.View)this.building).getFields();
    }

    private void assignmentModeClicked(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(true);
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(false);
        }
        this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((BuildingFarmer.View)this.building).assignFieldManually()) {
            this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
        } else {
            this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
        }
        this.fieldList = this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutFarmer.this.fields.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos field = (BlockPos)WindowHutFarmer.this.fields.get(index);
                String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(field, ((BuildingFarmer.View)WindowHutFarmer.this.building).getPosition())));
                String direction = BlockPosUtil.calcDirection(((BuildingFarmer.View)WindowHutFarmer.this.building).getPosition(), field);
                TileEntity entity = WindowHutFarmer.this.world.func_175625_s(field);
                if (entity instanceof TileEntityScarecrow) {
                    String owner = ((TileEntityScarecrow)entity).getOwner().isEmpty() ? "<" + LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.unused", new Object[0]) + ">" : ((TileEntityScarecrow)entity).getOwner();
                    rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_WORKER, Label.class).setLabelText(owner);
                    rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DISTANCE, Label.class).setLabelText(distance + "m");
                    rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DIRECTION, Label.class).setLabelText(direction);
                    Button assignButton = rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_BUTTON_ASSIGN, Button.class);
                    assignButton.setEnabled(((BuildingFarmer.View)WindowHutFarmer.this.building).assignFieldManually());
                    if (((TileEntityScarecrow)entity).isTaken()) {
                        assignButton.setLabel(WindowHutFarmer.RED_X);
                    } else {
                        assignButton.setLabel(WindowHutFarmer.APPROVE);
                        if (((BuildingFarmer.View)WindowHutFarmer.this.building).getBuildingLevel() <= ((BuildingFarmer.View)WindowHutFarmer.this.building).getAmountOfFields()) {
                            assignButton.disable();
                        }
                    }
                    if (((TileEntityScarecrow)entity).getSeed() != null) {
                        rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_ICON, ItemIcon.class).setItem(((TileEntityScarecrow)entity).getSeed());
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "tile.minecolonies.blockHutFarmer.name";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_FIELDS)) {
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
        }
    }
}

