/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.ClickGuiButtonTriggerMessage;
import com.minecolonies.coremod.network.messages.OpenGuiWindowTriggerMessage;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowSkeleton
extends Window
implements ButtonHandler {
    @NotNull
    private final HashMap<String, Consumer<Button>> buttons;
    protected final Label pageNum;
    protected final Button buttonPrevPage;
    protected final Button buttonNextPage;
    protected SwitchView switchView;
    private String resource;

    public AbstractWindowSkeleton(String resource) {
        super(resource);
        this.resource = resource;
        this.buttons = new HashMap();
        this.buttonNextPage = this.findPaneOfTypeByID("nextPage", Button.class);
        this.buttonPrevPage = this.findPaneOfTypeByID("prevPage", Button.class);
        this.pageNum = this.findPaneOfTypeByID("pageNum", Label.class);
        this.switchView = this.findPaneOfTypeByID("pages", SwitchView.class);
        MineColonies.getNetwork().sendToServer((IMessage)new OpenGuiWindowTriggerMessage(this.resource));
    }

    public final void registerButton(String id, Runnable action) {
        this.registerButton(id, (Button button) -> action.run());
    }

    public final void registerButton(String id, Consumer<Button> action) {
        this.buttons.put(id, action);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.setPage("prevPage");
                return;
            }
            case "nextPage": {
                this.setPage("nextPage");
                return;
            }
        }
        if (this.buttons.containsKey(button.getID())) {
            this.buttons.get(button.getID()).accept(button);
            MineColonies.getNetwork().sendToServer((IMessage)new ClickGuiButtonTriggerMessage(button.getID(), this.resource));
        } else {
            Log.getLogger().warn(this.getClass().getName() + ": Unhandled Button ID:" + button.getID());
        }
    }

    public final void doNothing(Button ignored) {
    }

    public void setPage(@NotNull String button) {
        int switchPagesSize = this.switchView.getChildrenSize();
        int curPage = this.pageNum.getLabelText().isEmpty() ? 1 : Integer.parseInt(this.pageNum.getLabelText().substring(0, this.pageNum.getLabelText().indexOf("/")));
        switch (button) {
            case "prevPage": {
                this.switchView.previousView();
                --curPage;
                break;
            }
            case "nextPage": {
                this.switchView.nextView();
                ++curPage;
                break;
            }
            default: {
                if (switchPagesSize != 1) break;
                this.buttonPrevPage.off();
                this.buttonNextPage.off();
                this.pageNum.off();
                return;
            }
        }
        this.buttonNextPage.on();
        this.buttonPrevPage.on();
        if (curPage == 1) {
            this.buttonPrevPage.off();
        }
        if (curPage == switchPagesSize) {
            this.buttonNextPage.off();
        }
        this.pageNum.setLabelText(curPage + "/" + switchPagesSize);
    }
}

