/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.Box;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.network.messages.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowRequestTree
extends AbstractWindowSkeleton {
    protected final IColonyView colony;
    protected ScrollingList resourceList;
    private final InventoryPlayer inventory;
    private final boolean isCreative;
    private int lifeCount;
    private final IBuildingView building;

    public AbstractWindowRequestTree(BlockPos building, String pane, IColonyView colony) {
        super(pane);
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
        this.lifeCount = 0;
        this.colony = colony;
        this.building = colony.getBuilding(building);
        this.registerButton("detail", this::detailedClicked);
        this.registerButton("cancel", this::cancel);
        if (this.canFulFill()) {
            this.registerButton("fulfill", this::fulfill);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!GuiScreen.func_146272_n()) {
            ++this.lifeCount;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.resourceList = this.findPaneOfTypeByID("requests", ScrollingList.class);
        if (this.building != null) {
            this.updateRequests();
        }
        if (this.colony == null) {
            Log.getLogger().warn("Colony and/or building null, closing window.");
            this.close();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestTreeOfBuilding().size() > row && row >= 0) {
            IRequest request = ((RequestWrapper)this.getOpenRequestTreeOfBuilding().get(row)).getRequest();
            this.building.onRequestedRequestCancelled(this.colony.getRequestManager(), request);
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.colony.getID(), (IToken)request.getId(), RequestState.CANCELLED, null));
        }
        this.updateRequests();
    }

    protected ImmutableList<RequestWrapper> getOpenRequestTreeOfBuilding() {
        if (this.colony == null) {
            return ImmutableList.of();
        }
        ArrayList treeElements = new ArrayList();
        if (this.building != null) {
            this.getOpenRequestsFromBuilding(this.building).forEach(r -> this.constructTreeFromRequest(this.building, this.colony.getRequestManager(), (IRequest<?>)r, treeElements, 0));
        }
        return ImmutableList.copyOf(treeElements);
    }

    private void constructTreeFromRequest(@NotNull IBuildingView buildingView, @NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull List<RequestWrapper> list, int currentDepth) {
        list.add(new RequestWrapper(request, currentDepth, buildingView));
        if (request.hasChildren()) {
            for (Object o : request.getChildren()) {
                IToken iToken;
                IRequest<?> childRequest;
                if (!(o instanceof IToken) || (childRequest = manager.getRequestForToken(iToken = (IToken)o)) == null) continue;
                this.constructTreeFromRequest(buildingView, manager, childRequest, list, currentDepth + 1);
            }
        }
    }

    public ImmutableList<IRequest> getOpenRequestsFromBuilding(IBuildingView building) {
        return building.getOpenRequestsOfBuilding();
    }

    public void fulfill(@NotNull Button button) {
    }

    public boolean canFulFill() {
        return false;
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestTreeOfBuilding().size() > row) {
            WindowRequestDetail window = new WindowRequestDetail(this, ((RequestWrapper)this.getOpenRequestTreeOfBuilding().get(row)).getRequest(), this.colony.getID());
            window.open();
        }
    }

    protected void updateRequests() {
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){
            private List<RequestWrapper> requestWrappers = null;

            @Override
            public int getElementCount() {
                this.requestWrappers = AbstractWindowRequestTree.this.getOpenRequestTreeOfBuilding();
                return this.requestWrappers.size();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                if (index < 0 || index >= this.requestWrappers.size()) {
                    return;
                }
                RequestWrapper wrapper = this.requestWrappers.get(index);
                Box wrapperBox = rowPane.findPaneOfTypeByID("requestx", Box.class);
                wrapperBox.setPosition(wrapperBox.getX() + 2 * wrapper.getDepth(), wrapperBox.getY());
                wrapperBox.setSize(wrapperBox.getParent().getWidth() - 2 * wrapper.getDepth(), wrapperBox.getHeight());
                rowPane.findPaneByID("fulfill").enable();
                IRequest request = wrapper.getRequest();
                ItemIcon exampleStackDisplay = rowPane.findPaneOfTypeByID("requestStack", ItemIcon.class);
                List<ItemStack> displayStacks = request.getDisplayStacks();
                Image logo = rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                if (!displayStacks.isEmpty()) {
                    logo.setVisible(false);
                    exampleStackDisplay.setVisible(true);
                    exampleStackDisplay.setItem(displayStacks.get(AbstractWindowRequestTree.this.lifeCount / 30 % displayStacks.size()));
                } else {
                    exampleStackDisplay.setVisible(false);
                    logo.setVisible(true);
                    logo.setImage(request.getDisplayIcon());
                }
                rowPane.findPaneOfTypeByID("requester", Label.class).setLabelText(request.getRequester().getRequesterDisplayName(AbstractWindowRequestTree.this.colony.getRequestManager(), request).func_150254_d());
                rowPane.findPaneOfTypeByID("shortDetail", Label.class).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
                if (wrapper.getDepth() > 0) {
                    rowPane.findPaneOfTypeByID("cancel", ButtonImage.class).hide();
                } else {
                    rowPane.findPaneOfTypeByID("cancel", ButtonImage.class).show();
                }
                if (wrapper.overruleable && AbstractWindowRequestTree.this.canFulFill()) {
                    if (wrapper.getDepth() > 0) {
                        if (!(request.getRequester() instanceof IBuildingBasedRequester) || !((IBuildingBasedRequester)request.getRequester()).getBuilding(AbstractWindowRequestTree.this.colony.getRequestManager(), (IToken<?>)request.getId()).map(iRequester -> iRequester.getLocation().equals(AbstractWindowRequestTree.this.building.getLocation())).isPresent()) {
                            rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                        } else {
                            request.getRequestOfType(IDeliverable.class).ifPresent(requestRequest -> {
                                if (!AbstractWindowRequestTree.this.isCreative) {
                                    if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)AbstractWindowRequestTree.this.inventory), requestRequest::matches)) {
                                        rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                                    }
                                }
                            });
                            if (!(request.getRequest() instanceof IDeliverable)) {
                                rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                            }
                        }
                        rowPane.findPaneOfTypeByID("cancel", ButtonImage.class).hide();
                    } else {
                        request.getRequestOfType(IDeliverable.class).ifPresent(requestRequest -> {
                            if (!AbstractWindowRequestTree.this.isCreative) {
                                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)AbstractWindowRequestTree.this.inventory), requestRequest::matches)) {
                                    rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                                }
                            }
                        });
                    }
                } else {
                    rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                }
            }
        });
    }

    protected final class RequestWrapper {
        private final IRequest request;
        private final int depth;
        private final boolean overruleable;

        public RequestWrapper(IRequest request, @NotNull int depth, IBuildingView buildingView) {
            this.request = request;
            this.depth = depth;
            this.overruleable = request.getRequester().getId().equals(buildingView.getId()) || buildingView.getResolverIds().contains((Object)request.getRequester().getId()) || buildingView.getPosition().equals((Object)request.getRequester().getLocation().getInDimensionLocation());
        }

        public IRequest getRequest() {
            return this.request;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

