/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockHutTownHall
extends AbstractBlockHut<BlockHutTownHall> {
    public static final float PVP_MODE_HARDNESS = 200.0f;

    public BlockHutTownHall() {
        if (Configurations.gameplay.pvp_mode) {
            this.func_149711_c(200.0f);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "blockHutTownHall";
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return ModBuildings.townHall;
    }

    @Override
    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            IColony colony = IColonyManager.getInstance().getClosestColony(worldIn, pos);
            String style = "wooden";
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityColonyBuilding && !((AbstractTileEntityColonyBuilding)tileEntity).getStyle().isEmpty()) {
                style = ((AbstractTileEntityColonyBuilding)tileEntity).getStyle();
            }
            if (colony == null || !IColonyManager.getInstance().isTooCloseToColony(worldIn, pos)) {
                if (Configurations.gameplay.enableDynamicColonySizes) {
                    IColony ownedColony = IColonyManager.getInstance().getIColonyByOwner(worldIn, (EntityPlayer)placer);
                    if (ownedColony == null) {
                        IColonyManager.getInstance().createColony(worldIn, pos, (EntityPlayer)placer, style);
                    } else {
                        ownedColony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, worldIn);
                    }
                } else {
                    IColonyManager.getInstance().createColony(worldIn, pos, (EntityPlayer)placer, style);
                }
            } else {
                colony.setStyle(style);
                colony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, worldIn);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }
}

