/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.func_77976_d()) continue;
            craftingCount = Math.max(ingredient.func_77976_d(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(@NotNull int count, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.func_77976_d()) continue;
            craftingCount = Math.max(ingredient.func_77976_d(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }
}

