/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends AbstractTileEntityColonyBuilding
implements ITickable {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private int colonyId = 0;
    private IColony colony;
    private IBuildingContainer building;
    private boolean mirror;
    private String style = "";
    private CombinedItemHandler combinedInv;
    private ResourceLocation registryName;

    public TileEntityColonyBuilding() {
    }

    public TileEntityColonyBuilding(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public IColony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.func_145831_w() != null) {
            this.colony = this.colonyId == 0 ? IColonyManager.getInstance().getColonyByPosFromWorld(this.func_145831_w(), this.func_174877_v()) : IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.func_145831_w());
            if (this.colony == null && !this.func_145831_w().field_72995_K) {
                Log.getLogger().warn(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] had colony.", this.func_145831_w().func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.func_145831_w() != null && this.func_145831_w().field_72995_K)) {
                this.building.setTileEntity(this);
            }
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        IBuildingContainer theBuilding = this.getBuilding();
        if (theBuilding != null) {
            if (TileEntityColonyBuilding.isInTileEntity((ICapabilityProvider)theBuilding.getTileEntity(), notEmptyPredicate)) {
                return theBuilding.getPosition();
            }
            for (BlockPos pos : theBuilding.getAdditionalCountainers()) {
                TileEntity entity = this.func_145831_w().func_175625_s(pos);
                if ((!(entity instanceof AbstractTileEntityRack) || !((AbstractTileEntityRack)entity).hasItemStack(notEmptyPredicate)) && (!(entity instanceof TileEntityChest) || !TileEntityColonyBuilding.isInTileEntity((ICapabilityProvider)entity, notEmptyPredicate))) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void setColony(IColony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        return new SPacketUpdateTileEntity(this.getPosition(), 0, compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.colonyId = compound.func_74762_e(TAG_COLONY);
    }

    public void onChunkUnload() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    @Override
    public IBuildingContainer getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    @Override
    public void setBuilding(IBuildingContainer b) {
        this.building = b;
    }

    public ITextComponent func_145748_c_() {
        if (this.field_145854_h == null) {
            return super.func_145748_c_();
        }
        return new TextComponentString(LanguageHandler.format(this.field_145854_h.func_149739_a() + ".name", new Object[0]));
    }

    @Override
    public IBuildingView getBuildingView() {
        IColonyView c = IColonyManager.getInstance().getColonyView(this.colonyId, this.field_145850_b.field_73011_w.getDimension());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(TAG_COLONY)) {
            this.colonyId = compound.func_74762_e(TAG_COLONY);
        }
        this.updateColonyReferences();
        this.mirror = compound.func_74767_n(TAG_MIRROR);
        this.style = compound.func_74779_i(TAG_STYLE);
        this.registryName = new ResourceLocation(compound.func_74779_i("type"));
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        compound.func_74757_a(TAG_MIRROR, this.mirror);
        compound.func_74778_a(TAG_STYLE, this.style);
        compound.func_74778_a("type", this.registryName.toString());
        return compound;
    }

    public void func_73660_a() {
        IColony tempColony;
        if (!this.func_145831_w().field_72995_K && this.colonyId == 0 && (tempColony = IColonyManager.getInstance().getColonyByPosFromWorld(this.func_145831_w(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        this.combinedInv = null;
    }

    @Override
    public boolean hasAccessPermission(EntityPlayer player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    @Override
    public boolean isMirrored() {
        return this.mirror;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public ResourceLocation getBuildingName() {
        return this.registryName;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                HashSet<ICapabilityProvider> providers = new HashSet<ICapabilityProvider>();
                World world = this.colony.getWorld();
                if (world != null) {
                    providers.addAll(this.building.getAdditionalCountainers().stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).collect(Collectors.toSet()));
                    providers.removeIf(Objects::isNull);
                    providers.removeIf(p -> p instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)p).field_174879_c.equals((Object)this.field_174879_c));
                }
                List handlers = providers.stream().flatMap(provider -> InventoryUtils.getItemHandlersFromProvider(provider).stream()).collect(Collectors.toList());
                T cap = super.getCapability(capability, facing);
                if (cap instanceof IItemHandler) {
                    handlers.add((IItemHandler)cap);
                }
                this.combinedInv = new CombinedItemHandler(this.building.getSchematicName(), (IItemHandlerModifiable[])handlers.stream().filter(handler -> handler instanceof IItemHandlerModifiable && handler.getSlots() >= 5).map(handler -> (IItemHandlerModifiable)handler).distinct().toArray(IItemHandlerModifiable[]::new));
            }
            return (T)this.combinedInv;
        }
        return super.getCapability(capability, facing);
    }
}

