/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String INPUT_TAG = "input";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public RecipeStorage getNewInstance(IToken token, List<ItemStack> input, int gridSize, ItemStack primaryOutput, Block intermediate) {
        return new RecipeStorage(token, input, gridSize, primaryOutput, intermediate);
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList inputTagList = new NBTTagList();
        for (ItemStack stack : recipeStorage.getInput()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            stack.func_77955_b(neededRes);
            inputTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(INPUT_TAG, (NBTBase)inputTagList);
        recipeStorage.getPrimaryOutput().func_77955_b(compound);
        if (recipeStorage.getIntermediate() != null) {
            NBTUtil.func_190009_a((NBTTagCompound)compound, (IBlockState)recipeStorage.getIntermediate().func_176223_P());
        }
        compound.func_74768_a(TAG_GRID, recipeStorage.getGridSize());
        compound.func_74782_a("Token", (NBTBase)StandardFactoryController.getInstance().serialize(recipeStorage.getToken()));
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        NBTTagList inputTagList = nbt.func_150295_c(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.func_74745_c(); ++i) {
            NBTTagCompound inputTag = inputTagList.func_150305_b(i);
            input.add(new ItemStack(inputTag));
        }
        ItemStack primaryOutput = new ItemStack(nbt);
        Block intermediate = NBTUtil.func_190008_d((NBTTagCompound)nbt).func_177230_c();
        int gridSize = nbt.func_74762_e(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(nbt.func_74775_l("Token"));
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate);
    }
}

