/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.ICitizenAssignable;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuildingWorker
extends ISchematicProvider,
ICitizenAssignable,
IBuildingContainer,
IBuilding {
    public static final int WOOD_HUT_LEVEL = 0;

    public static boolean canBuildingCanLearnMoreRecipes(int buildingLevel, int learnedRecipes) {
        return Math.pow(2.0, buildingLevel) >= (double)(learnedRecipes + 1);
    }

    @NotNull
    public IJob createJob(ICitizenData var1);

    public boolean isItemStackInRequest(@Nullable ItemStack var1);

    public void setHiringMode(HiringMode var1);

    public HiringMode getHiringMode();

    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack var1);

    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> var1);

    public IRecipeStorage getFirstFullFillableRecipe(ItemStack var1);

    public IRecipeStorage getFirstFullFillableRecipe(ItemStack var1, int var2);

    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> var1, int var2);

    public boolean fullFillRecipe(IRecipeStorage var1);

    public void switchIndex(int var1, int var2);

    public boolean canRecipeBeAdded(IToken var1);

    public List<IToken> getRecipes();

    public List<IItemHandler> getHandlers();

    @Override
    public boolean assignCitizen(ICitizenData var1);

    public boolean addRecipe(IToken var1);

    public void removeRecipe(IToken var1);

    @NotNull
    public String getJobName();

    public int getMaxToolLevel();

    public boolean canWorkDuringTheRain();

    public boolean canCraftComplexRecipes();

    public static enum Skill {
        STRENGTH,
        ENDURANCE,
        CHARISMA,
        INTELLIGENCE,
        DEXTERITY,
        PLACEHOLDER;

    }
}

