/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.NBTUtils;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IChunkmanagerCapability {
    @Nullable
    public ChunkLoadStorage getChunkStorage(int var1, int var2);

    public boolean addChunkStorage(int var1, int var2, ChunkLoadStorage var3);

    public Map<ChunkPos, ChunkLoadStorage> getAllChunkStorages();

    public static class Storage
    implements Capability.IStorage<IChunkmanagerCapability> {
        public NBTBase writeNBT(@NotNull Capability<IChunkmanagerCapability> capability, @NotNull IChunkmanagerCapability instance, @Nullable EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("allchunk", (NBTBase)instance.getAllChunkStorages().entrySet().stream().map(entry -> Storage.write((ChunkPos)entry.getKey(), (ChunkLoadStorage)entry.getValue())).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IChunkmanagerCapability> capability, @NotNull IChunkmanagerCapability instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
            if (nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("allchunk")) {
                NBTUtils.streamCompound(((NBTTagCompound)nbt).func_150295_c("allchunk", 10)).map(Storage::read).forEach(key -> instance.addChunkStorage(((ChunkPos)key.func_76341_a()).field_77276_a, ((ChunkPos)key.func_76341_a()).field_77275_b, (ChunkLoadStorage)key.func_76340_b()));
            }
        }

        private static NBTTagCompound write(ChunkPos key, ChunkLoadStorage value) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("chunk", (NBTBase)value.toNBT());
            compound.func_74768_a("xPos", key.field_77276_a);
            compound.func_74768_a("zPos", key.field_77275_b);
            return compound;
        }

        private static Tuple<ChunkPos, ChunkLoadStorage> read(NBTTagCompound compound) {
            ChunkLoadStorage storage = new ChunkLoadStorage(compound.func_74775_l("chunk"));
            int x = compound.func_74762_e("xPos");
            int z = compound.func_74762_e("zPos");
            return new Tuple((Object)new ChunkPos(x, z), (Object)storage);
        }
    }

    public static class Impl
    implements IChunkmanagerCapability {
        private final Map<ChunkPos, ChunkLoadStorage> chunkStorages = new THashMap();

        @Override
        @Nullable
        public ChunkLoadStorage getChunkStorage(int chunkX, int chunkZ) {
            return this.chunkStorages.remove(new ChunkPos(chunkX, chunkZ));
        }

        @Override
        public boolean addChunkStorage(int chunkX, int chunkZ, ChunkLoadStorage storage) {
            ChunkLoadStorage existingStorage = this.chunkStorages.get(new ChunkPos(chunkX, chunkZ));
            if (existingStorage == null) {
                this.chunkStorages.put(new ChunkPos(chunkX, chunkZ), storage);
                return false;
            }
            existingStorage.merge(storage);
            return true;
        }

        @Override
        public Map<ChunkPos, ChunkLoadStorage> getAllChunkStorages() {
            return this.chunkStorages;
        }
    }
}

