/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.world;

import epicsquid.mysticallib.world.GenerationNode;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class GenerationData
extends WorldSavedData {
    private Set<GenerationNode> nodes = new HashSet<GenerationNode>();

    public GenerationData(@Nonnull String name) {
        super(name);
    }

    public GenerationData() {
        this("mysticallib_generation_data");
    }

    public void addNode(@Nonnull GenerationNode node) {
        this.nodes.add(node);
        this.func_76185_a();
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("gen_data_nodes", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.nodes.add(new GenerationNode(list.func_150305_b(i)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (GenerationNode g : this.nodes) {
            list.func_74742_a((NBTBase)g.writeToNBT());
        }
        compound.func_74782_a("gen_data_nodes", (NBTBase)list);
        return compound;
    }

    public static GenerationData get(@Nonnull World w) {
        MapStorage s = w.getPerWorldStorage();
        GenerationData d = (GenerationData)s.func_75742_a(GenerationData.class, "mysticallib_generation_data");
        if (d == null) {
            d = new GenerationData();
            s.func_75745_a("mysticallib_generation_data", (WorldSavedData)d);
        }
        return d;
    }

    public void update(@Nonnull World world) {
        HashSet<GenerationNode> toDelete = new HashSet<GenerationNode>();
        for (GenerationNode n : this.nodes) {
            if (n != null) {
                n.update(world);
            }
            if (n != null && n.isAlive) continue;
            toDelete.add(n);
        }
        for (GenerationNode n : toDelete) {
            this.nodes.remove(n);
        }
        toDelete.clear();
    }
}

