/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelPressurePlate
extends BakedModelBlock {
    private Cube cube_on;
    private Cube cube_off;

    public BakedModelPressurePlate(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.cube_on = ModelUtil.makeCube(format, 0.0625, 0.0, 0.0625, 0.875, 0.03125, 0.875, null, texes, 0).setNoCull(EnumFacing.DOWN);
        this.cube_off = ModelUtil.makeCube(format, 0.0625, 0.0, 0.0625, 0.875, 0.0625, 0.875, null, texes, 0).setNoCull(EnumFacing.DOWN);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable EnumFacing side, @Nullable IBlockState state) {
        if (state == null) {
            this.cube_off.addToList(quads, side);
        } else {
            boolean on = (Boolean)state.func_177229_b((IProperty)BlockPressurePlate.field_176580_a);
            if (on) {
                this.cube_on.addToList(quads, side);
            } else {
                this.cube_off.addToList(quads, side);
            }
        }
    }
}

