/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.solar;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.config.config.SolarConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.solar.ISolarPanelNetwork;
import crazypants.enderio.machines.machine.solar.ISolarType;
import crazypants.enderio.machines.machine.solar.SolarType;
import crazypants.enderio.machines.machine.solar.TileSolarPanel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SolarPanelNetwork
implements ISolarPanelNetwork {
    @Nonnull
    private final Set<BlockPos> panels = new HashSet<BlockPos>();
    @Nonnull
    private final World world;
    private boolean valid = false;
    private int energyMaxPerTick = 0;
    private int energyAvailablePerTick = 0;
    private int energyAvailableThisTick = 0;
    private long lastTick = -1L;
    private long nextCollectTick = 0L;
    private int energyMaxPerTickPerPanel = -1;

    public static void build(@Nonnull TileSolarPanel panel) {
        new SolarPanelNetwork(panel).isValid();
    }

    private SolarPanelNetwork(@Nonnull TileSolarPanel panel) {
        this.world = panel.func_145831_w();
        this.valid = true;
        this.panels.add(panel.func_174877_v().func_185334_h());
        panel.setNetwork(this);
        this.nextCollectTick = 0L;
        this.cleanupMemberlist();
    }

    @Override
    @Nonnull
    public Set<BlockPos> getPanels() {
        return this.panels;
    }

    void cleanupMemberlist() {
        if (!this.panels.isEmpty()) {
            Iterator<BlockPos> iterator = this.panels.iterator();
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            while (iterator.hasNext()) {
                TileEntity tileEntity;
                BlockPos panel = iterator.next();
                if (panel != null && this.world.func_175667_e(panel) && (tileEntity = this.world.func_175625_s(panel)) instanceof TileSolarPanel && !tileEntity.func_145837_r() && tileEntity.func_145830_o() && ((TileSolarPanel)tileEntity).network == this) {
                    NNList.NNIterator facings = NNList.FACING_HORIZONTAL.fastIterator();
                    while (facings.hasNext()) {
                        BlockPos neighbor = panel.func_177972_a((EnumFacing)facings.next());
                        if (this.panels.contains(neighbor) || !this.world.func_175667_e(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                    continue;
                }
                iterator.remove();
            }
            while (!candidates.isEmpty()) {
                NNList candidateList = new NNList(candidates);
                for (BlockPos candidate : candidateList) {
                    TileEntity tileEntity;
                    if (!this.panels.contains(candidate) && this.canConnect(candidate) && (tileEntity = this.world.func_175625_s(candidate)) instanceof TileSolarPanel && !tileEntity.func_145837_r() && tileEntity.func_145830_o()) {
                        this.panels.add(candidate.func_185334_h());
                        ISolarPanelNetwork otherNetwork = ((TileSolarPanel)tileEntity).network;
                        if (otherNetwork != this) {
                            ((TileSolarPanel)tileEntity).setNetwork(this);
                            for (BlockPos other : otherNetwork.getPanels()) {
                                if (other == null || this.panels.contains(other) || !this.world.func_175667_e(other)) continue;
                                candidates.add(other);
                            }
                            otherNetwork.destroyNetwork();
                            NNList.NNIterator facings = NNList.FACING_HORIZONTAL.fastIterator();
                            while (facings.hasNext()) {
                                BlockPos neighbor = candidate.func_177972_a((EnumFacing)facings.next());
                                if (this.panels.contains(neighbor) || !this.world.func_175667_e(neighbor)) continue;
                                candidates.add(neighbor);
                            }
                        }
                    }
                    candidates.remove(candidate);
                }
            }
        }
        if (this.panels.isEmpty()) {
            this.destroyNetwork();
        }
    }

    private boolean canConnect(@Nonnull BlockPos other) {
        if (((Boolean)SolarConfig.canSolarTypesJoin.get()).booleanValue() || this.panels.isEmpty()) {
            return true;
        }
        IBlockState otherState = this.world.func_180495_p(other);
        if (otherState.func_177230_c() == MachineObject.block_solar_panel.getBlock()) {
            for (BlockPos panel : this.panels) {
                IBlockState state;
                if (panel == null || !this.world.func_175667_e(panel) || (state = this.world.func_180495_p(panel)).func_177230_c() != MachineObject.block_solar_panel.getBlock()) continue;
                return ((ISolarType)state.func_177229_b((IProperty)SolarType.KIND)).connectTo((ISolarType)otherState.func_177229_b((IProperty)SolarType.KIND));
            }
        }
        return false;
    }

    @Override
    public void destroyNetwork() {
        this.energyAvailableThisTick = 0;
        this.energyAvailablePerTick = 0;
        this.energyMaxPerTick = 0;
        this.nextCollectTick = Long.MAX_VALUE;
        this.panels.clear();
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private void updateEnergy() {
        long tick = EnderIO.proxy.getServerTickCount();
        if (tick != this.lastTick) {
            this.lastTick = tick;
            if (tick > this.nextCollectTick) {
                this.nextCollectTick = tick + (long)((Integer)SolarConfig.solarRecalcSunTick.get()).intValue();
                this.energyAvailablePerTick = 0;
                this.energyMaxPerTick = 0;
                float lightRatio = TileSolarPanel.calculateLightRatio(this.world);
                for (BlockPos panel : this.panels) {
                    if (panel == null || !this.world.func_175667_e(panel)) continue;
                    if (this.energyMaxPerTickPerPanel < 0 || ((Boolean)SolarConfig.canSolarTypesJoin.get()).booleanValue()) {
                        this.energyMaxPerTickPerPanel = TileSolarPanel.getEnergyPerTick(this.world, panel);
                        if (this.energyMaxPerTickPerPanel < 0) {
                            this.destroyNetwork();
                            return;
                        }
                    }
                    this.energyMaxPerTick += this.energyMaxPerTickPerPanel;
                    this.energyAvailablePerTick += MathHelper.func_76141_d((float)((float)this.energyMaxPerTickPerPanel * TileSolarPanel.calculateLocalLightRatio(this.world, panel, lightRatio)));
                }
            }
            this.energyAvailableThisTick = this.energyAvailablePerTick;
        }
    }

    @Override
    public void extractEnergy(int maxExtract) {
        this.energyAvailableThisTick = Math.max(this.energyAvailableThisTick - maxExtract, 0);
    }

    @Override
    public int getEnergyAvailableThisTick() {
        this.updateEnergy();
        return this.energyAvailableThisTick;
    }

    @Override
    public int getEnergyAvailablePerTick() {
        this.updateEnergy();
        return this.energyAvailablePerTick;
    }

    @Override
    public int getEnergyMaxPerTick() {
        this.updateEnergy();
        return this.energyMaxPerTick;
    }

    @Override
    @Nonnull
    public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer player, @Nullable EnumFacing side) {
        NNList result = new NNList();
        TextComponentTranslation text = Lang.PROBE_SOLAR_LAST.toChatServer(EnderIO.proxy.getServerTickCount() - this.lastTick);
        result.add((Object)Lang.PROBE_SOLAR_PROD.toChatServer(this.panels.size(), this.getEnergyAvailablePerTick(), this.getEnergyMaxPerTick()));
        result.add((Object)text);
        for (BlockPos panel : this.panels) {
            if (TileSolarPanel.isPowered(this.world, panel)) continue;
            result.add((Object)Lang.PROBE_SOLAR_NOSUN.toChatServer(BlockCoord.chatString((BlockPos)panel, (TextFormatting)TextFormatting.RESET)));
        }
        if (result.size() == 2) {
            result.add((Object)Lang.PROBE_SOLAR_ALLSUN.toChatServer());
        }
        return result;
    }

    public String toString() {
        return "SolarPanelNetwork [panels=" + this.panels.size() + ", valid=" + this.valid + ", energyMaxPerTick=" + this.energyMaxPerTick + ", energyAvailablePerTick=" + this.energyAvailablePerTick + ", energyAvailableThisTick=" + this.energyAvailableThisTick + ", lastTick=" + this.lastTick + ", nextCollectTick=" + this.nextCollectTick + ", rfMax=" + this.energyMaxPerTickPerPanel + "]";
    }
}

