/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.blockiterators.PlanarBlockIterator;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.collect.Iterators;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.api.farm.IFertilizer;
import crazypants.enderio.api.farm.IFertilizerResult;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.fertilizer.Fertilizer;
import crazypants.enderio.base.farming.registry.Commune;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.network.PacketSpawnParticles;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.FarmConfig;
import crazypants.enderio.machines.machine.farm.BlockFarmStation;
import crazypants.enderio.machines.machine.farm.FarmLogic;
import crazypants.enderio.machines.machine.farm.FarmSlots;
import crazypants.enderio.machines.machine.farm.PacketFarmAction;
import crazypants.enderio.machines.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machines.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machines.machine.farm.TicketFarmingStation;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import org.apache.commons.lang3.tuple.Pair;

@Storable
public class TileFarmStation
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged,
INotifier,
ITankAccess.IExtendedTankAccess {
    public static final int NUM_TOOL_SLOTS = 3;
    public static final int minToolSlot = 0;
    public static final int maxToolSlot = 2;
    public static final int NUM_FERTILIZER_SLOTS = 2;
    public static final int minFirtSlot = 3;
    public static final int maxFirtSlot = 4;
    public static final int NUM_SUPPLY_SLOTS = 4;
    public static final int minSupSlot = 5;
    public static final int maxSupSlot = 8;
    @Store
    private int lockedSlots = 0;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    @Nonnull
    private NNList<ItemStack> overflowQueue = new NNList();
    @Nonnull
    private final Set<FarmNotification> notification = EnumSet.noneOf(FarmNotification.class);
    private boolean sendNotification = false;
    private boolean wasActive;
    private EnumMap<FarmingTool, FarmSlots> toolmapping = new EnumMap(FarmingTool.class);
    private boolean toolmappingInitialized = false;
    private IFarmer farmerCache;
    private int bonemealCooldown = 4;
    private PlanarBlockIterator blockIterator;
    @Nonnull
    private final List<BlockPos> boostCoords = new ArrayList<BlockPos>();
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.5686275f, 0.32156864f, 0.08235294f, 0.4f);
    private BoundingBox wateringBounds;
    @Nonnull
    private final TicketFarmingStation ticket;
    @Store
    @Nonnull
    protected final SmartTank tank = new SmartTank(FluidRegistry.WATER, ((Integer)FarmConfig.waterTankSize.get()).intValue());
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileFarmStation() {
        super(new SlotDefinition(9, 6, 1), CapacitorKey.FARM_POWER_INTAKE, CapacitorKey.FARM_POWER_BUFFER, CapacitorKey.FARM_POWER_USE);
        this.ticket = new TicketFarmingStation(this);
        this.tank.setTileEntity((TileEntity)this);
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this::getSmartTankFluidHandler);
    }

    public int getFarmSize() {
        return (int)(CapacitorKey.FARM_BASE_SIZE.getFloat(this.getCapacitorData()) + CapacitorKey.FARM_BONUS_SIZE.getFloat(this.getCapacitorData()));
    }

    public void setSingleNotification(@Nonnull FarmNotification note) {
        this.setNotification(note);
        Iterator<FarmNotification> itr = this.notification.iterator();
        while (itr.hasNext()) {
            if (itr.next() == note) continue;
            itr.remove();
            this.sendNotification = true;
        }
    }

    public void setNotification(@Nonnull FarmNotification note) {
        if (!this.notification.contains(note)) {
            this.notification.add(note);
            this.sendNotification = true;
        }
    }

    public void removeNotification(FarmNotification note) {
        if (this.getNotification().remove(note)) {
            this.sendNotification = true;
        }
    }

    public void clearNotification(boolean all) {
        if (this.hasNotification()) {
            if (all) {
                this.getNotification().clear();
                this.sendNotification = true;
            } else {
                Iterator<FarmNotification> itr = this.notification.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().isAutoCleanup()) continue;
                    itr.remove();
                    this.sendNotification = true;
                }
            }
        }
    }

    public boolean hasNotification() {
        return !this.getNotification().isEmpty();
    }

    private void sendNotification() {
        PacketHandler.sendToAllAround((IMessage)new PacketUpdateNotification(this, this.notification), (TileEntity)this);
        this.sendNotification = false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        if (i <= 2) {
            FarmingTool toolType = FarmingTool.getToolType(stack);
            if (toolType != FarmingTool.NONE && !TicProxy.isBroken(stack) && !FarmingTool.isDryRfTool(stack)) {
                return this.getSlotForTool(toolType) == null;
            }
            return false;
        }
        if (i <= 4) {
            return Fertilizer.isFertilizer(stack);
        }
        if (i <= 8) {
            return this.isSlotLocked(i) ? ItemUtil.areStacksEqual((ItemStack)stack, (ItemStack)this.getStackInSlot(i)) : Commune.instance.canPlant(stack);
        }
        return false;
    }

    private void buildToolmapping() {
        if (!this.toolmappingInitialized || this.field_145850_b.field_72995_K) {
            this.toolmapping.clear();
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(0)), FarmSlots.TOOL1);
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(1)), FarmSlots.TOOL2);
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(2)), FarmSlots.TOOL3);
            this.toolmappingInitialized = true;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.toolmappingInitialized = false;
    }

    protected FarmSlots getSlotForTool(@Nonnull IFarmingTool tool) {
        this.buildToolmapping();
        return this.toolmapping.get(tool);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Override
    protected void checkProgress(boolean redstoneChecksPassed) {
        if (this.shouldDoWorkThisTick(1200)) {
            this.clearNotification(false);
        }
        if (redstoneChecksPassed) {
            if (this.getCapacitorData() == DefaultCapacitorData.NONE) {
                this.setSingleNotification(FarmNotification.NO_CAP);
            } else if (this.tryToUsePower()) {
                this.removeNotification(FarmNotification.NO_POWER);
                if (this.shouldDoWorkThisTick(10 - this.getEnergyStoredScaled(8))) {
                    if (this.isOutputFull()) {
                        this.setNotification(FarmNotification.OUTPUT_FULL);
                    } else {
                        this.removeNotification(FarmNotification.OUTPUT_FULL);
                        this.doTick();
                    }
                    this.doBoost();
                }
            } else {
                this.setSingleNotification(FarmNotification.NO_POWER);
            }
        }
        if (this.sendNotification) {
            this.sendNotification();
        }
    }

    @Nonnull
    private IFarmer getFarmer() {
        return this.farmerCache != null ? this.farmerCache : (this.farmerCache = new FarmLogic(this));
    }

    @Nullable
    protected BlockPos findNextPos() {
        int i = 20;
        while (i-- > 0) {
            BlockPos farmingPos = this.getNextCoord();
            if (farmingPos.equals((Object)this.func_174877_v()) || !this.field_145850_b.func_175667_e(farmingPos) || !PermissionAPI.hasPermission((GameProfile)this.getOwner().getAsGameProfile(), (String)BlockFarmStation.permissionFarming, (IContext)new BlockPosContext((EntityPlayer)this.getFarmer().getFakePlayer(), farmingPos, this.field_145850_b.func_180495_p(farmingPos), null))) continue;
            return farmingPos;
        }
        return null;
    }

    protected void doTick() {
        BlockPos farmingPos = this.findNextPos();
        if (farmingPos == null) {
            return;
        }
        IBlockState bs = this.field_145850_b.func_180495_p(farmingPos);
        if (this.isOpen(farmingPos, bs)) {
            switch (Commune.instance.tryPrepareBlock(this.getFarmer(), farmingPos, bs)) {
                case ACTION: {
                    PacketHandler.sendToAllAround(new PacketFarmAction(farmingPos), (TileEntity)this);
                }
                case CLAIM: {
                    return;
                }
            }
        }
        if (this.isOpen(farmingPos, bs) || !this.executeHarvest(farmingPos, bs)) {
            this.executeBonemeal(farmingPos, bs);
        }
    }

    private void executeBonemeal(@Nonnull BlockPos farmingPos, @Nonnull IBlockState bs) {
        ItemStack fertStack;
        IFertilizer fertilizer;
        boolean doApply;
        IFarmer farmer = this.getFarmer();
        if (this.hasBonemeal() && this.bonemealCooldown-- <= 0 && this.random.nextFloat() <= ((Float)FarmConfig.farmBonemealChance.get()).floatValue() && farmer.checkAction(FarmingAction.FERTILIZE, FarmingTool.HAND) && (doApply = (fertilizer = Fertilizer.getInstance(fertStack = this.getStackInSlot(3))).applyOnPlant() && fertilizer.applyOnAir() ? !this.isOpen(farmingPos, bs) || this.field_145850_b.func_175623_d(farmingPos) : (fertilizer.applyOnPlant() ? !this.isOpen(farmingPos, bs) : (fertilizer.applyOnAir() ? this.field_145850_b.func_175623_d(farmingPos) : true)))) {
            FakePlayer farmerJoe = farmer.startUsingItem(Prep.getEmpty());
            IFertilizerResult result = fertilizer.apply(fertStack, (EntityPlayer)farmerJoe, this.field_145850_b, farmingPos);
            if (result.wasApplied()) {
                this.setInventorySlotContents(3, result.getStack());
                PacketHandler.sendToAllAround(new PacketFarmAction(farmingPos), (TileEntity)this);
                this.bonemealCooldown = (Integer)FarmConfig.farmBonemealDelaySuccess.get();
                farmer.registerAction(FarmingAction.FERTILIZE, FarmingTool.HAND);
            } else {
                this.usePower((Integer)FarmConfig.farmBonemealEnergyUseFail.get());
                this.bonemealCooldown = (Integer)FarmConfig.farmBonemealDelayFail.get();
            }
            farmer.handleExtraItems(farmer.endUsingItem(false), farmingPos);
        }
    }

    private boolean isOpen(@Nonnull BlockPos farmingPos, @Nonnull IBlockState bs) {
        return this.field_145850_b.func_175623_d(farmingPos) || bs.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, farmingPos);
    }

    private boolean executeHarvest(@Nonnull BlockPos farmingPos, @Nonnull IBlockState bs) {
        IHarvestResult harvest = Commune.instance.harvestBlock(this.getFarmer(), farmingPos, bs);
        if (!(harvest == null || harvest.getHarvestedBlocks().isEmpty() && harvest.getDrops().isEmpty())) {
            if (!harvest.getHarvestedBlocks().isEmpty()) {
                PacketHandler.sendToAllAround(new PacketFarmAction((List<BlockPos>)harvest.getHarvestedBlocks()), (TileEntity)this);
            }
            NNList.wrap(harvest.getDrops()).apply((NNList.Callback)new NNList.Callback<Pair<BlockPos, ItemStack>>(){

                public void apply(@Nonnull Pair<BlockPos, ItemStack> ei) {
                    ItemStack stack = (ItemStack)ei.getValue();
                    if (stack != null && Prep.isValid(stack)) {
                        TileFarmStation.this.getFarmer().handleExtraItem(stack, (BlockPos)ei.getLeft());
                    }
                }
            });
            return true;
        }
        return false;
    }

    private boolean hasBonemeal() {
        for (FarmSlots slot : FarmSlots.FERTS) {
            if (!Prep.isValid(slot.get(this))) continue;
            if (slot != FarmSlots.FERT1) {
                FarmSlots.FERT1.set(this, slot.get(this));
                slot.set(this, Prep.getEmpty());
            }
            return true;
        }
        return false;
    }

    private boolean isOutputFull() {
        if (!this.overflowQueue.isEmpty()) {
            NNList<ItemStack> old = this.overflowQueue;
            this.overflowQueue = new NNList();
            this.getFarmer().handleExtraItems((NonNullList<ItemStack>)old, this.field_174879_c);
        }
        if (((Boolean)FarmConfig.useOutputQueue.get()).booleanValue()) {
            return !this.overflowQueue.isEmpty();
        }
        for (FarmSlots slot : FarmSlots.OUTPUTS) {
            ItemStack curStack = slot.get(this);
            if (!Prep.isInvalid(curStack) && (((Boolean)FarmConfig.farmStopOnNoOutputSlots.get()).booleanValue() || curStack.func_190916_E() >= curStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private BlockPos getNextCoord() {
        if (this.blockIterator == null || !this.blockIterator.hasNext()) {
            this.blockIterator = new PlanarBlockIterator(this.func_174877_v(), PlanarBlockIterator.Orientation.HORIZONTAL, this.getFarmSize());
        }
        return this.blockIterator.next();
    }

    @Nonnull
    private BlockPos getNextBoostCoord() {
        if (this.boostCoords.isEmpty()) {
            Iterators.addAll(this.boostCoords, (Iterator)new PlanarBlockIterator(this.func_174877_v(), PlanarBlockIterator.Orientation.HORIZONTAL, this.getFarmSize()));
            Collections.shuffle(this.boostCoords);
        }
        return this.boostCoords.isEmpty() ? this.field_174879_c : (BlockPos)NullHelper.first((Object[])new BlockPos[]{this.boostCoords.remove(this.boostCoords.size() - 1), this.field_174879_c});
    }

    private void doBoost() {
        this.ticket.prepare();
        if (((Boolean)FarmConfig.enableCarefulCare.get()).booleanValue()) {
            if ((Integer)FarmConfig.waterCarefulCare.get() == 0 || !this.hasTank() || !this.tank.isEmpty()) {
                for (float boost = CapacitorKey.FARM_BOOST.getFloat(this.getCapacitorData()) / 100.0f; boost > 0.0f; boost -= 1.0f) {
                    IBlockState blockState;
                    Block block;
                    BlockPos boostPos = this.getNextBoostCoord();
                    if (!(boost >= 1.0f) && !(this.random.nextFloat() < boost) || !this.field_145850_b.func_175667_e(boostPos) || !(block = (blockState = this.field_145850_b.func_180495_p(boostPos)).func_177230_c()).func_149653_t()) continue;
                    block.func_180645_a(this.field_145850_b, boostPos, blockState, this.field_145850_b.field_73012_v);
                    this.tank.drainInternal(((Integer)FarmConfig.waterCarefulCare.get()).intValue(), true);
                }
                if (!this.tank.isEmpty()) {
                    this.removeNotification(FarmNotification.NO_WATER);
                }
            } else {
                this.setNotification(FarmNotification.NO_WATER);
            }
        }
    }

    public void toggleLockedState(int slot) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((IMessage)new PacketFarmLockedSlot(this, slot));
        }
        this.setSlotLocked(slot, !this.isSlotLocked(slot));
    }

    public boolean isSlotLocked(FarmSlots slot) {
        return (this.lockedSlots & slot.getBitmask()) != 0;
    }

    public boolean isSlotLocked(int slot) {
        return (this.lockedSlots & 1 << slot - 5) != 0;
    }

    private void setSlotLocked(int slot, boolean value) {
        this.lockedSlots = value ? (this.lockedSlots |= 1 << slot - 5) : (this.lockedSlots &= ~(1 << slot - 5));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "farmingstation";
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.currentTask = this.createTask(null, 0L);
        this.wateringBounds = new BoundingBox(this.func_174877_v().func_177977_b()).expand((double)this.getRange(), 0.0, (double)this.getRange());
    }

    @Override
    protected IPoweredTask createTask(@Nullable IMachineRecipe nextRecipe, long nextSeed) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        if (slot >= 0 && slot <= 2) {
            return 1;
        }
        if (slot >= 5 && slot <= 8) {
            return this.getCapacitorData() == DefaultCapacitorData.NONE ? 0 : Math.min(CapacitorKey.FARM_STACK_LIMIT.get(this.getCapacitorData()), 64);
        }
        return 64;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimit(5);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileFarmStation>(this, color));
        }
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand((double)this.getRange(), 0.0, (double)this.getRange());
    }

    public float getRange() {
        return this.getFarmSize();
    }

    public boolean hasTank() {
        return (Integer)FarmConfig.waterTankSize.get() > 0;
    }

    public boolean canWater(@Nonnull Vec3d toMatch) {
        if (this.redstoneCheckPassed && this.wateringBounds != null && this.hasPower() && this.wateringBounds.func_72318_a(toMatch)) {
            if ((Integer)FarmConfig.waterPerFarmland.get() == 0 || !this.hasTank() || !this.tank.isEmpty()) {
                this.tank.drainInternal(((Integer)FarmConfig.waterPerFarmland.get()).intValue(), true);
                if (((Boolean)FarmConfig.waterFarmlandParticles.get()).booleanValue()) {
                    PacketSpawnParticles.create(this.field_145850_b, new BlockPos(toMatch).func_177981_b(2), EnumParticleTypes.WATER_DROP, EnumParticleTypes.WATER_SPLASH, EnumParticleTypes.PORTAL);
                }
                if (!this.tank.isEmpty()) {
                    this.removeNotification(FarmNotification.NO_WATER);
                }
                return true;
            }
            this.setNotification(FarmNotification.NO_WATER);
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.ticket.invalidate();
    }

    @Override
    protected int usePower(int wantToUse) {
        return super.usePower(wantToUse);
    }

    protected IFluidHandler getSmartTankFluidHandler(EnumFacing facingIn) {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler.get(facingIn);
    }

    @Nonnull
    public Set<FarmNotification> getNotification() {
        return this.notification;
    }

    public void enQueueOverflow(@Nonnull ItemStack stack) {
        this.overflowQueue.add((Object)stack);
    }

    @Nullable
    public FluidTank getInputTank(FluidStack forFluidType) {
        if (this.tank.canFill(forFluidType)) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.func_70296_d();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileFarmStation.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileFarmStation.this.tank.getCapacity();
            }
        });
    }
}

