/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.client;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.client.ItemEntry;
import crazypants.enderio.invpanel.invpanel.GuiInventoryPanel;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.invpanel.network.PacketFetchItem;
import crazypants.enderio.invpanel.util.StoredCraftingRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CraftingHelper {
    @Nonnull
    final NNList<ItemStack>[] ingredients;

    public CraftingHelper(@Nonnull NNList<ItemStack>[] ingredients) {
        this.ingredients = ingredients;
    }

    @Nonnull
    public static CraftingHelper createFromRecipe(StoredCraftingRecipe recipe) {
        NNList[] ingredients = new NNList[9];
        for (int idx = 0; idx < 9; ++idx) {
            ItemStack stack = recipe.get(idx);
            if (stack.func_190926_b()) continue;
            ingredients[idx] = new NNList((Object[])new ItemStack[]{stack});
        }
        return new CraftingHelper(ingredients);
    }

    @Nullable
    public static CraftingHelper createFromSlots(@Nonnull List<Slot> slots) {
        if (slots.size() != 9) {
            return null;
        }
        NNList[] ingredients = new NNList[9];
        int count = 0;
        for (int idx = 0; idx < 9; ++idx) {
            Slot slot = slots.get(idx);
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            ingredients[idx] = new NNList((Object[])new ItemStack[]{stack});
            ++count;
        }
        if (count > 0) {
            return new CraftingHelper(ingredients);
        }
        return null;
    }

    public void install() {
    }

    public void remove() {
    }

    public void refill(@Nonnull GuiInventoryPanel gui, int amount) {
        InventoryPanelContainer container = gui.getContainer();
        this.refill(container, amount);
    }

    public void refill(@Nonnull InventoryPanelContainer container, int amount) {
        boolean madeProgress;
        InventoryDatabaseClient db = ((TileInventoryPanel)container.getTe()).getDatabaseClient();
        if (db == null) {
            return;
        }
        List<Slot> craftingGrid = container.getCraftingGridSlots();
        int slotsToProcess = 511;
        int maxAmount = 64;
        do {
            int idx;
            Candidate candidate;
            Candidate[] candidates = new Candidate[9];
            for (int idx2 = 0; idx2 < 9; ++idx2) {
                if ((slotsToProcess & 1 << idx2) == 0) continue;
                NNList<ItemStack> pstack = this.ingredients[idx2];
                Slot slot = craftingGrid.get(idx2);
                ItemStack stack = slot.func_75211_c();
                if (pstack == null) {
                    if (stack.func_190926_b()) continue;
                    return;
                }
                if (!stack.func_190926_b()) {
                    if (!CraftingHelper.isStackCompatible(pstack, stack)) {
                        return;
                    }
                    candidate = this.findCandidates(stack, container, db, candidates);
                } else {
                    candidate = this.findAllCandidates(pstack, container, db, candidates);
                }
                if (candidate == null) {
                    return;
                }
                ++candidate.used;
                candidates[idx2] = candidate;
            }
            int targetAmount = maxAmount;
            int currentAmount = 0;
            for (idx = 0; idx < 9; ++idx) {
                Candidate candidate2 = candidates[idx];
                if (candidate2 == null) continue;
                Slot slot = craftingGrid.get(idx);
                int current = CraftingHelper.getSlotStackSize(slot);
                int maxStackSize = candidate2.stack.func_77976_d();
                currentAmount = Math.max(currentAmount, current);
                if (!candidate2.stack.func_77985_e() || maxStackSize <= 1) continue;
                targetAmount = Math.min(targetAmount, current + Math.min(maxStackSize, candidate2.getAvailable()));
            }
            targetAmount = Math.min(targetAmount, currentAmount + amount);
            madeProgress = false;
            for (idx = 0; idx < 9; ++idx) {
                int mask = 1 << idx;
                candidate = candidates[idx];
                if (candidate == null) continue;
                Slot slot = craftingGrid.get(idx);
                for (Slot srcSlot : candidate.sourceSlots) {
                    int current = CraftingHelper.getSlotStackSize(slot);
                    if (current >= targetAmount) break;
                    if (!container.moveItems(srcSlot.field_75222_d, slot.field_75222_d, slot.field_75222_d + 1, targetAmount - current)) continue;
                    slotsToProcess &= ~mask;
                    madeProgress = true;
                }
                int current = CraftingHelper.getSlotStackSize(slot);
                if (candidate.entry != null && current < targetAmount) {
                    int toMove = Math.min(candidate.entry.getCount(), targetAmount - current);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFetchItem(db.getGeneration(), candidate.entry, slot.field_75222_d, toMove));
                    slotsToProcess &= ~mask;
                    current += toMove;
                }
                if (current <= 0) continue;
                maxAmount = Math.min(maxAmount, current);
            }
        } while (madeProgress && slotsToProcess != 0);
    }

    private static int getSlotStackSize(@Nonnull Slot slot) {
        ItemStack stack = slot.func_75211_c();
        return stack.func_190916_E();
    }

    private static boolean isStackCompatible(@Nonnull NNList<ItemStack> pstack, @Nonnull ItemStack stack) {
        for (ItemStack istack : pstack) {
            if (!ItemUtil.areStackMergable((ItemStack)stack, (ItemStack)istack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Candidate findAllCandidates(@Nonnull NNList<ItemStack> pstack, @Nonnull InventoryPanelContainer container, @Nonnull InventoryDatabaseClient db, @Nonnull Candidate[] candidates) {
        Candidate bestInventory = null;
        Candidate bestNetwork = null;
        for (ItemStack istack : pstack) {
            Candidate candidate = this.findCandidates(istack, container, db, candidates);
            if (candidate.available > 0 && (bestInventory == null || bestInventory.available < candidate.available)) {
                bestInventory = candidate;
            }
            if (candidate.entry == null || bestNetwork != null && bestNetwork.entry.getCount() >= candidate.entry.getCount()) continue;
            bestNetwork = candidate;
        }
        if (bestInventory != null) {
            return bestInventory;
        }
        return bestNetwork;
    }

    @Nonnull
    private Candidate findCandidates(@Nonnull ItemStack stack, @Nonnull InventoryPanelContainer container, @Nonnull InventoryDatabaseClient db, @Nonnull Candidate[] candidates) {
        for (Candidate candidate : candidates) {
            if (candidate == null || !ItemUtil.areStackMergable((ItemStack)candidate.stack, (ItemStack)stack)) continue;
            return candidate;
        }
        Candidate candidate = new Candidate(stack);
        if (((TileInventoryPanel)container.getTe()).isExtractionDisabled()) {
            this.findCandidates(candidate, stack, container.getReturnAreaSlots());
        }
        this.findCandidates(candidate, stack, container.getPlayerInventorySlots());
        this.findCandidates(candidate, stack, container.getPlayerHotbarSlots());
        if (candidate.available == 0 && db != null) {
            candidate.entry = db.lookupItem(stack, null, false);
            if (candidate.entry != null && candidate.entry.getCount() <= 0) {
                candidate.entry = null;
            }
        }
        return candidate;
    }

    private void findCandidates(@Nonnull Candidate candidates, @Nonnull ItemStack stack, @Nonnull Collection<Slot> slots) {
        for (Slot slot : slots) {
            ItemStack slotStack = slot.func_75211_c();
            if (!ItemUtil.areStackMergable((ItemStack)slotStack, (ItemStack)stack)) continue;
            candidates.sourceSlots.add(slot);
            candidates.available += slotStack.func_190916_E();
        }
    }

    static class Candidate {
        @Nonnull
        final ItemStack stack;
        final ArrayList<Slot> sourceSlots = new ArrayList();
        ItemEntry entry;
        int available;
        int used;

        public Candidate(@Nonnull ItemStack stack) {
            this.stack = stack;
        }

        public int getAvailable() {
            int avail = this.available;
            if (this.entry != null) {
                avail += this.entry.getCount();
            }
            if (avail > 0 && this.used > 1) {
                avail = Math.max(1, avail / this.used);
            }
            return avail;
        }
    }
}

