/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.filters;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.integration.forestry.filters.SpeciesItemFilter;
import crazypants.enderio.integration.forestry.filters.SpeciesMode;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class SpeciesItemFilterGui
extends AbstractFilterGui {
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    private static final int ID_SPECIES_MODE = FilterGuiUtil.nextButtonId();
    private static final int ID_STICKY = FilterGuiUtil.nextButtonId();
    private final IconButton whiteListB;
    private final CycleButton<SpeciesMode.IconHolder> speciesModeB;
    private final ToggleButton stickyB;
    @Nonnull
    private final SpeciesItemFilter filter;
    private int buttonIdOffset;
    private int xOffset;
    private int yOffset;

    public SpeciesItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filter) {
        this(playerInv, filterContainer, te, 13, 34, 0, filter);
    }

    public SpeciesItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, int xOffset, int yOffset, int buttonIdOffset, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn, "advanced_item_filter");
        int butLeft;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.buttonIdOffset = buttonIdOffset;
        this.filter = (SpeciesItemFilter)filterIn;
        int x = butLeft = xOffset + 98;
        int y = yOffset + 1;
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST + buttonIdOffset, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        this.stickyB = new ToggleButton((IGuiScreen)this, ID_STICKY + buttonIdOffset, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_ENABLED.get(), Lang.GUI_ITEM_FILTER_STICKY_ENABLED_2.get()});
        this.stickyB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_DISABLED.get()});
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.speciesModeB = new CycleButton((IGuiScreen)this, ID_SPECIES_MODE + buttonIdOffset, x, y += 20, SpeciesMode.IconHolder.class);
    }

    @Override
    public void func_73866_w_() {
        this.createFilterSlots();
        super.func_73866_w_();
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots(), this.xOffset + 1, this.yOffset + 1, new Runnable(){

            @Override
            public void run() {
                SpeciesItemFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        if (this.isStickyModeAvailable) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(this.filter.isSticky());
        }
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
        this.speciesModeB.onGuiInit();
        this.speciesModeB.setMode((Enum)SpeciesMode.IconHolder.getFromMode(this.filter.getSpeciesMode()));
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == ID_STICKY + this.buttonIdOffset) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_SPECIES_MODE + this.buttonIdOffset) {
            this.filter.setSpeciesMode(((SpeciesMode.IconHolder)this.speciesModeB.getMode()).getMode());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST + this.buttonIdOffset) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_SPECIES_ITEM_FILTER.get();
    }
}

