/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.gui.LiquidSettings;
import crazypants.enderio.util.EnumReader;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractLiquidConduit
extends AbstractConduit
implements ILiquidConduit {
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);
    private int ticksSinceFailedExtract;
    protected boolean reenter = false;

    @Nullable
    public IFluidWrapper getExternalHandler(@Nonnull EnumFacing direction) {
        BlockPos pos;
        World world = this.getBundle().getBundleworld();
        TileEntity tileEntity = world.func_175625_s(pos = this.getBundle().getLocation().func_177972_a(direction));
        if (tileEntity instanceof IConduitBundle) {
            return null;
        }
        return FluidWrapper.wrap((TileEntity)tileEntity, (EnumFacing)direction.func_176734_d());
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreDisabled) {
        return this.getExternalHandler(direction) != null;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Override
    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(@Nonnull EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.NEVER;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    @Nonnull
    public DyeColor getExtractionSignalColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean canOutputToDir(@Nonnull EnumFacing dir) {
        if (!this.canInputToDir(dir)) {
            return false;
        }
        if (this.conduitConnections.contains(dir)) {
            return true;
        }
        return this.externalConnections.contains(dir);
    }

    protected boolean autoExtractForDir(@Nonnull EnumFacing dir) {
        return this.canExtractFromDir(dir) && ConduitUtil.isRedstoneControlModeMet(this, this.getExtractionRedstoneMode(dir), this.getExtractionSignalColor(dir), dir);
    }

    @Override
    public boolean canExtractFromDir(@Nonnull EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsInput();
    }

    @Override
    public boolean canInputToDir(@Nonnull EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsOutput() && !this.autoExtractForDir(dir);
    }

    protected boolean hasExtractableMode() {
        if (this.hasExternalConnections()) {
            for (EnumFacing side : this.getExternalConnections()) {
                if (side == null || !this.canExtractFromDir(side)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K) {
            this.doExtract();
        }
    }

    protected void doExtract() {
        if (!this.hasExtractableMode() || this.getNetwork() == null) {
            return;
        }
        if ((this.ticksSinceFailedExtract++ & 0xF) != 0) {
            return;
        }
        for (EnumFacing dir : this.getExternalConnections()) {
            if (dir == null || !this.autoExtractForDir(dir) || !this.doExtract(dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    protected abstract boolean doExtract(@Nonnull EnumFacing var1);

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, EnumReader.get(DyeColor.class, dataRoot.func_74765_d("extractionSignalColor")));
        this.setExtractionRedstoneMode(RedstoneControlMode.fromOrdinal(dataRoot.func_74765_d("extractionRedstoneMode")), dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            String key = "extRM." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "extSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.extractionColors.put(dir, DyeColor.values()[ord]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new LiquidSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof LiquidSettings) {
            return ((LiquidSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 1;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getExternalConnections().contains(facing);
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getFluidDir(facing);
        }
        return null;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidDir(@Nullable EnumFacing dir) {
        if (dir != null) {
            return new ConnectionLiquidSide(dir);
        }
        return null;
    }

    protected class ConnectionLiquidSide
    implements IFluidHandler {
        @Nonnull
        protected EnumFacing side;

        public ConnectionLiquidSide(EnumFacing side) {
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (AbstractLiquidConduit.this.reenter) {
                return new FluidTankProperties[0];
            }
            try {
                AbstractLiquidConduit.this.reenter = true;
                IFluidTankProperties[] iFluidTankPropertiesArray = AbstractLiquidConduit.this.getTankProperties();
                return iFluidTankPropertiesArray;
            }
            finally {
                AbstractLiquidConduit.this.reenter = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int fill(FluidStack resource, boolean doFill) {
            if (!AbstractLiquidConduit.this.reenter && AbstractLiquidConduit.this.canFill(this.side, resource)) {
                try {
                    AbstractLiquidConduit.this.reenter = true;
                    int n = AbstractLiquidConduit.this.fill(resource, doFill);
                    return n;
                }
                finally {
                    AbstractLiquidConduit.this.reenter = false;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!AbstractLiquidConduit.this.reenter && AbstractLiquidConduit.this.canDrain(this.side, resource)) {
                try {
                    AbstractLiquidConduit.this.reenter = true;
                    FluidStack fluidStack = AbstractLiquidConduit.this.drain(resource, doDrain);
                    return fluidStack;
                }
                finally {
                    AbstractLiquidConduit.this.reenter = false;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!AbstractLiquidConduit.this.reenter && AbstractLiquidConduit.this.canDrain(this.side, null)) {
                try {
                    AbstractLiquidConduit.this.reenter = true;
                    FluidStack fluidStack = AbstractLiquidConduit.this.drain(maxDrain, doDrain);
                    return fluidStack;
                }
                finally {
                    AbstractLiquidConduit.this.reenter = false;
                }
            }
            return null;
        }
    }
}

