/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import com.google.common.math.BigIntegerMath;
import com.google.common.math.LongMath;
import crazypants.enderio.util.MathUtil;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class XpUtil {
    public static final long RATIO = 20L;
    private static final int MAX_LEVEL_INT = 21862;
    private static final int MAX_LEVEL_LONG = 0x55555567;
    private static final long LVLOFFSET32 = -XpUtil.calculateXPfromLevelHigh(32) + XpUtil.calculateXPfromLevelLow(32);
    private static final BigInteger B72 = BigInteger.valueOf(72L);
    private static final BigInteger B54215 = BigInteger.valueOf(54215L);
    private static final BigInteger B325 = BigInteger.valueOf(325L);
    private static final BigInteger B18 = BigInteger.valueOf(18L);

    public static int liquidToExperience(int liquid) {
        return (int)((long)liquid / 20L);
    }

    public static long liquidToExperience(long liquid) {
        return liquid / 20L;
    }

    public static int experienceToLiquid(int xp) {
        return Math.multiplyExact(xp, 20);
    }

    public static long experienceToLiquid(long xp) {
        return Math.multiplyExact(xp, 20L);
    }

    public static int getMaxLevelsStorable() {
        return 21862;
    }

    public static int getMaxLevelsStorableL() {
        return 0x55555567;
    }

    public static int getExperienceForLevel(int level) {
        if (level < 0) {
            throw new ArithmeticException("level underflow");
        }
        return Math.toIntExact(XpUtil.calculateXPfromLevel(level));
    }

    public static long getExperienceForLevelL(int level) {
        if (level < 0) {
            throw new ArithmeticException("level underflow");
        }
        if (level > 0x55555567) {
            return Long.MAX_VALUE;
        }
        return XpUtil.calculateXPfromLevel(level);
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return -158 + level * 9;
        }
        if (level >= 15) {
            return -38 + level * 5;
        }
        if (level >= 0) {
            return 7 + level * 2;
        }
        throw new ArithmeticException("level underflow");
    }

    private static long calculateXPfromLevel(int level) {
        if (level >= 32) {
            return XpUtil.calculateXPfromLevelHigh(level) + LVLOFFSET32;
        }
        return XpUtil.calculateXPfromLevelLow(level);
    }

    private static long calculateXPfromLevelHigh(int level) {
        return -158L * ((long)level + 1L) + MathUtil.termial(level - 1) * 9L;
    }

    private static long calculateXPfromLevelLow(int level) {
        if (level >= 1 && level <= 16) {
            return (long)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level >= 17 && level <= 31) {
            return (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        if (level >= 32) {
            return (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return 0L;
    }

    public static int getLevelForExperience(long experience) {
        return XpUtil.getLevelFromExp(experience);
    }

    public static int getLevelForExperienceWithChecks(long experience) {
        int guess = XpUtil.getLevelFromExp(experience);
        long high = XpUtil.calculateXPfromLevel(guess + 1);
        long low = XpUtil.calculateXPfromLevel(guess);
        if (experience >= low && (experience < high || high < low)) {
            return guess;
        }
        System.out.println("guess: " + guess + " levels");
        System.out.println("low: " + low);
        System.out.println("XP: " + experience);
        System.out.println("high: " + high);
        throw new ArithmeticException("level calculation error");
    }

    private static int getLevelFromExp(long exp) {
        if (exp > 0x1C71C71C71C71C7L) {
            return BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(exp).multiply(B72).subtract(B54215), (RoundingMode)RoundingMode.DOWN).add(B325).divide(B18).intValueExact();
        }
        if (exp > Integer.MAX_VALUE) {
            return (int)((LongMath.sqrt((long)(72L * exp - 54215L), (RoundingMode)RoundingMode.DOWN) + 325L) / 18L);
        }
        if (exp > 1395L) {
            return (int)((Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt(exp + 9L) - 3.0);
        }
        return 0;
    }

    public static int getPlayerXP(@Nonnull EntityPlayer player) throws TooManyXPLevelsException {
        try {
            return player.field_71075_bZ.field_75098_d ? 0x3FFFFFFF : Math.addExact(XpUtil.getExperienceForLevel(player.field_71068_ca), (int)(player.field_71106_cc * (float)player.func_71050_bK()));
        }
        catch (ArithmeticException e) {
            throw new TooManyXPLevelsException();
        }
    }

    public static long getPlayerXPL(@Nonnull EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0x3FFFFFFFL : Math.addExact(XpUtil.getExperienceForLevelL(player.field_71068_ca), (long)(player.field_71106_cc * (float)player.func_71050_bK()));
    }

    public static void addPlayerXP(@Nonnull EntityPlayer player, int amount) throws TooManyXPLevelsException {
        try {
            int experience;
            player.field_71067_cb = experience = Math.max(0, Math.addExact(XpUtil.getPlayerXP(player), amount));
            player.field_71068_ca = XpUtil.getLevelForExperience(experience);
            int expForLevel = XpUtil.getExperienceForLevel(player.field_71068_ca);
            player.field_71106_cc = (float)(experience - expForLevel) / (float)XpUtil.getXpBarCapacity(player.field_71068_ca);
        }
        catch (ArithmeticException e) {
            throw new TooManyXPLevelsException();
        }
    }

    public static void addPlayerXP(@Nonnull EntityPlayer player, long amount) throws TooManyXPLevelsException {
        try {
            long experience = Math.max(0L, Math.addExact(XpUtil.getPlayerXPL(player), amount));
            player.field_71067_cb = MathUtil.limit(experience);
            player.field_71068_ca = XpUtil.getLevelForExperience(experience);
            long expForLevel = XpUtil.getExperienceForLevelL(player.field_71068_ca);
            player.field_71106_cc = (float)(experience - expForLevel) / (float)XpUtil.getXpBarCapacity(player.field_71068_ca);
        }
        catch (ArithmeticException e) {
            throw new TooManyXPLevelsException();
        }
    }

    public static class TooManyXPLevelsException
    extends Exception {
        private static final long serialVersionUID = -3819421185545900261L;
    }
}

