/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.slicensplice;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.AbstractMachineRecipe;
import crazypants.enderio.base.recipe.BasicManyToOneRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class SliceAndSpliceRecipeManager
extends AbstractMachineRecipe {
    @Nonnull
    private static final String NAME = "Slice'N'Splice";
    @Nonnull
    private static final SliceAndSpliceRecipeManager instance = new SliceAndSpliceRecipeManager();
    @Nonnull
    private final NNList<IManyToOneRecipe> recipes = new NNList();

    @Nonnull
    public static SliceAndSpliceRecipeManager getInstance() {
        return instance;
    }

    private SliceAndSpliceRecipeManager() {
    }

    public void create() {
        MachineRecipeRegistry.instance.registerRecipe(this);
    }

    @Nonnull
    public NNList<IManyToOneRecipe> getRecipes() {
        return this.recipes;
    }

    public void addRecipe(@Nonnull Recipe rec) {
        this.addRecipe(new BasicManyToOneRecipe(rec));
    }

    public void addRecipe(@Nonnull IManyToOneRecipe recipe) {
        IRecipe rec = this.getRecipeForStacks(recipe.getInputStacks());
        if (rec != null) {
            Log.warn("The supplied recipe " + recipe + " for " + NAME + " may be a duplicate to: " + rec);
        }
        this.addRecipeInternal(recipe);
    }

    protected void addRecipeInternal(IManyToOneRecipe recipe) {
        this.recipes.add((Object)recipe);
    }

    private IRecipe getRecipeForStacks(@Nonnull NNList<ItemStack> inputs) {
        NNList ins = new NNList();
        for (ItemStack stack : inputs) {
            ins.add((Object)new MachineRecipeInput(-1, (ItemStack)NullHelper.notnullM((Object)stack, (String)"NNList iterated with null")));
        }
        return this.getRecipeForInputs(RecipeLevel.IGNORE, (NNList<MachineRecipeInput>)ins);
    }

    @Override
    public IRecipe getRecipeForInputs(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        for (IManyToOneRecipe rec : this.recipes) {
            if (!machineLevel.canMake(rec.getRecipeLevel()) || !rec.isInputForRecipe(inputs)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        if (Prep.isInvalid(input.item)) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!machineLevel.canMake(recipe.getRecipeLevel())) continue;
            for (IRecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input.item) || ri.getSlotNumber() != -1 && input.slotNumber != ri.getSlotNumber()) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public List<IManyToOneRecipe> getRecipesThatHaveTheseAsValidRecipeComponents(@Nonnull NNList<ItemStack> input) {
        ArrayList<IManyToOneRecipe> result = new ArrayList<IManyToOneRecipe>();
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!recipe.isValidRecipeComponents(input)) continue;
            result.add(recipe);
        }
        return result;
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        for (IManyToOneRecipe recipe : this.recipes) {
            if (recipe.getOutput().func_77973_b() != output.func_77973_b() || recipe.getOutput().func_77952_i() != output.func_77952_i()) continue;
            return recipe.getOutputs()[0].getExperiance();
        }
        return 0.0f;
    }

    @Override
    @Nonnull
    public String getUid() {
        return "SpliceAndSpliceRecipe";
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "slicensplice";
    }
}

