/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.material;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.util.Prep;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialCraftingHandler {
    @Nonnull
    private static final Random RANDOM = new Random();
    @Nonnull
    private static final Map<BlockPos, Long> fires = new HashMap<BlockPos, Long>();
    @Nonnull
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("enderio", "infinity");
    @Nonnull
    private static final Set<ResourceLocation> SEEN = new HashSet<ResourceLocation>();

    @SubscribeEvent
    public static void on(BlockEvent.NeighborNotifyEvent event) {
        if (((Boolean)InfinityConfig.inWorldCraftingFireEnabled.get()).booleanValue()) {
            World world = event.getWorld();
            if (!(world instanceof WorldServer) || !InfinityConfig.isEnabledInDimension(world.field_73011_w.getDimension())) {
                return;
            }
            boolean isFire = event.getState().func_177230_c() instanceof BlockFire;
            if (fires.isEmpty() && !isFire) {
                return;
            }
            BlockPos pos = event.getPos();
            BlockPos posIdx = pos.func_177981_b(world.field_73011_w.getDimension() * 256);
            long worldTime = world.func_82737_E();
            if (isFire && ((Things)InfinityConfig.bedrock.get()).contains(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                if (fires.size() > 100) {
                    Iterator<Long> iterator = fires.values().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() >= worldTime && fires.size() <= 500) continue;
                        iterator.remove();
                    }
                }
                fires.putIfAbsent(posIdx, worldTime + (long)((Integer)InfinityConfig.fireMinAge.get()).intValue());
            } else if (fires.containsKey(posIdx)) {
                if (world.func_175623_d(pos) && ((Things)InfinityConfig.bedrock.get()).contains(world.func_180495_p(pos.func_177977_b()).func_177230_c()) && worldTime > fires.get(posIdx)) {
                    MaterialCraftingHandler.spawnInfinityPowder((WorldServer)world, pos, LOOT_TABLE);
                }
                fires.remove(posIdx);
            }
        }
    }

    public static void spawnInfinityPowder(@Nonnull WorldServer world, @Nonnull BlockPos pos, @Nonnull ResourceLocation table) {
        ResourceLocation subTable = new ResourceLocation(table.func_110624_b(), table.func_110623_a() + "/" + world.func_180495_p(pos.func_177977_b()).func_177230_c().getRegistryName().toString().replaceAll("[:]", "/").replaceAll("[^a-z0-9_/]", "_"));
        LootTable lootTable = world.func_184146_ak().func_186521_a(subTable);
        if (lootTable == LootTable.field_186464_a) {
            lootTable = world.func_184146_ak().func_186521_a(table);
            if (SEEN.add(subTable)) {
                Log.info("Would have used loot table " + subTable + " for infinity crafting but it doesn't exist.");
            }
        }
        for (ItemStack itemstack : lootTable.func_186462_a(RANDOM, new LootContext.Builder(world).func_186471_a())) {
            if (itemstack == null || !Prep.isValid(itemstack)) continue;
            double d0 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(RANDOM.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem((World)world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack);
            entityitem.func_174869_p();
            entityitem.func_70097_a(DamageSource.field_76372_a, -100.0f);
            entityitem.func_70015_d(10);
            world.func_72838_d((Entity)entityitem);
            if (!((Boolean)InfinityConfig.makesSound.get()).booleanValue()) continue;
            world.func_184133_a(null, pos, SoundEvents.field_187625_bm, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (!fires.isEmpty() && !event.world.func_82736_K().func_82766_b("doFireTick") && ((Boolean)InfinityConfig.inWorldCraftingEnabled.get()).booleanValue() && InfinityConfig.isEnabledInDimension(event.world.field_73011_w.getDimension())) {
            int yOffset = event.world.field_73011_w.getDimension() * 256;
            long worldTime = event.world.func_82737_E();
            for (Map.Entry<BlockPos, Long> fire : fires.entrySet()) {
                BlockPos posIdx = fire.getKey();
                BlockPos pos = posIdx.func_177979_c(yOffset);
                if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255 || worldTime <= fire.getValue()) continue;
                if (event.world.func_180495_p(pos).func_177230_c() instanceof BlockFire) {
                    event.world.func_175698_g(pos);
                } else {
                    fires.remove(posIdx);
                }
                return;
            }
        }
    }
}

