/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.IRecipeRoot;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Serializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class RecipeFactory {
    @Nonnull
    private static final String ASSETS_FOLDER_CONFIG = "config/";
    @Nonnull
    private static final String DEFAULT_USER_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<enderio:recipes xmlns:enderio=\"http://enderio.com/recipes\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://enderio.com/recipes recipes.xsd \">\n\n</enderio:recipes>\n";
    @Nonnull
    private final File configDirectory;
    @Nonnull
    private final String domain;
    public static boolean ENABLE_TESTING = false;

    public RecipeFactory(@Nonnull File configDirectory, @Nonnull String domain) {
        this.configDirectory = configDirectory;
        this.domain = domain;
    }

    private InputStream getResource(ResourceLocation resourceLocation) throws IOException {
        ModContainer container = Loader.instance().activeModContainer();
        if (container != null) {
            String resourcePath = String.format("/%s/%s/%s", "assets", resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
            InputStream resourceAsStream = container.getMod().getClass().getResourceAsStream(resourcePath);
            if (resourceAsStream != null) {
                return resourceAsStream;
            }
            throw new IOException("Could not find resource " + resourceLocation);
        }
        throw new RuntimeException("Failed to find current mod while looking for resource " + resourceLocation);
    }

    public void placeXSD(String folderName) {
        ResourceLocation xsdRL = new ResourceLocation(this.domain, "config/recipes/recipes.xsd");
        File xsdFL = new File(this.configDirectory, folderName + "/recipes.xsd");
        this.copyCore_dontMakeShittyCoreModsPlease_thisIncludesShittyMixins(xsdRL, xsdFL);
    }

    public void createFolder(String name) {
        File folderF;
        if (!this.configDirectory.exists()) {
            this.configDirectory.mkdir();
        }
        if (!(folderF = new File(this.configDirectory, name)).exists()) {
            folderF.mkdir();
        }
    }

    public NNList<File> listXMLFiles(String pathName) {
        return new NNList((Object[])new File(this.configDirectory, pathName).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !"sagmill_oresalleasy.xml".equals(name);
            }
        }));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends IRecipeRoot> T readCoreFile(T target, String rootElement, String fileName) throws IOException, XMLStreamException {
        ResourceLocation coreRL = new ResourceLocation(this.domain, ASSETS_FOLDER_CONFIG + fileName);
        Log.debug("Reading core recipe file " + fileName);
        Throwable throwable = null;
        try (InputStream coreFileStream = this.getResource(coreRL);){
            T t = RecipeFactory.readStax(target, rootElement, coreFileStream, "core recipe file '" + fileName + "'");
            return t;
        }
        catch (XMLStreamException e) {
            try {
                try (InputStream resource = this.getResource(coreRL);){
                    RecipeFactory.printContentsOnError(resource, coreRL.toString());
                    throw e;
                }
                catch (InvalidRecipeConfigException irce) {
                    irce.setFilename(fileName);
                    throw irce;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void copyCore(String fileName) {
        this.copyCore(fileName, null);
    }

    public void copyCore(String fileName, @Nullable String fallback) {
        File coreFL;
        ResourceLocation coreRL = new ResourceLocation(this.domain, ASSETS_FOLDER_CONFIG + fileName);
        if (!this.copyCore_dontMakeShittyCoreModsPlease_thisIncludesShittyMixins(coreRL, coreFL = new File(this.configDirectory, fileName)) && fallback != null) {
            this.copyCore(fallback, null);
        }
    }

    public void createFileUser(String fileName) {
        File userFL = new File(this.configDirectory, fileName);
        if (!userFL.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(userFL, false));){
                writer.write(DEFAULT_USER_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IRecipeRoot> T readFileUser(T target, String rootElement, String fileName, File userFL) throws IOException, XMLStreamException {
        if (!userFL.exists()) {
            Log.info("Skipping missing user recipe file " + fileName);
            return target;
        }
        Log.info("Reading user recipe file " + fileName);
        Throwable throwable = null;
        try (FileInputStream userFileStream = userFL.exists() ? new FileInputStream(userFL) : null;){
            T t = RecipeFactory.readStax(target, rootElement, userFileStream, "user recipe file '" + fileName + "'");
            return t;
        }
        catch (XMLStreamException e) {
            try {
                try (FileInputStream stream = new FileInputStream(userFL);){
                    RecipeFactory.printContentsOnError(stream, userFL.toString());
                    throw e;
                }
                catch (InvalidRecipeConfigException irce) {
                    irce.setFilename(fileName);
                    throw irce;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <T extends IRecipeRoot> T readFileIMC(T target, String rootElement, String fileName) throws IOException, XMLStreamException {
        File file = new File(fileName);
        if (file.exists()) {
            Log.info("Reading IMC recipe file " + fileName);
            Throwable throwable = null;
            try (FileInputStream userFileStream = new FileInputStream(file);){
                T t = RecipeFactory.readStax(target, rootElement, userFileStream, "IMC file '" + fileName + "'");
                return t;
            }
            catch (InvalidRecipeConfigException irce) {
                try {
                    irce.setFilename(fileName);
                    throw irce;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        throw new FileNotFoundException("IMC file '" + fileName + "' doesn't exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void printContentsOnError(InputStream stream, String filename) throws FileNotFoundException, IOException {
        try {
            Log.error("Failed to parse xml from file '", filename, "'. Content:");
            int data = 0;
            while (data != -1) {
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    data = stream.read();
                    if (data != -1) {
                        sb1.append(String.format("%02x ", data));
                        if (data > 32 && data < 128) {
                            sb2.appendCodePoint(data);
                            continue;
                        }
                        sb2.append(".");
                        continue;
                    }
                    sb1.append("   ");
                }
                Log.error(sb1, sb2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    protected static <T extends IRecipeRoot> T readStax(T target, String rootElement, InputStream in, String source) throws XMLStreamException, InvalidRecipeConfigException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        StaxFactory factory = new StaxFactory(eventReader, source);
        T result = factory.readRoot(target, rootElement);
        if (ENABLE_TESTING && result != null) {
            try {
                System.out.println(Serializer.serialize(result));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void cleanFolder(String folderName) {
        String[] list;
        File folder = new File(this.configDirectory, folderName);
        if (folder.exists() && (list = folder.list((file, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".xml") || name.toLowerCase(Locale.ENGLISH).endsWith(".pdf"))) != null) {
            for (String name2 : list) {
                File file2 = new File(folder, name2);
                Log.debug("Removing existing core recipe template file ", file2);
                file2.setWritable(true, true);
                file2.delete();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean copyCore_dontMakeShittyCoreModsPlease_thisIncludesShittyMixins(ResourceLocation resourceLocation, File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

