/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.init;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.features.IWirelessTermHandler;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.LoaderState;
import p455w0rd.ae2wtlib.AE2WTLib;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTRegistry;
import p455w0rd.ae2wtlib.api.item.ItemWT;
import p455w0rd.ae2wtlib.helpers.IWirelessUniversalItem;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibLogger;
import p455w0rd.ae2wtlib.recipe.RecipeNewTerminal;
import p455w0rdslib.api.client.IModelHolder;

public class LibWTRegistry
extends WTRegistry {
    private static final List<ICustomWirelessTerminalItem> WT_REGISTRY = new ArrayList<ICustomWirelessTerminalItem>();
    private static final Map<ICustomWirelessTerminalItem, ICustomWirelessTerminalItem> WT_TO_CREATIVE = new HashMap<ICustomWirelessTerminalItem, ICustomWirelessTerminalItem>();

    @Override
    public List<ICustomWirelessTerminalItem> getRegisteredTerminals() {
        return this.getRegisteredTerminals(false);
    }

    @Override
    public List<ICustomWirelessTerminalItem> getRegisteredTerminals(boolean excludeWUT) {
        if (excludeWUT) {
            ArrayList tmpList = Lists.newArrayList(WT_REGISTRY);
            Iterator listIterator = tmpList.iterator();
            while (listIterator.hasNext()) {
                ICustomWirelessTerminalItem currentTerminal = (ICustomWirelessTerminalItem)listIterator.next();
                if (!(currentTerminal instanceof IWirelessUniversalItem)) continue;
                listIterator.remove();
            }
            return tmpList;
        }
        return WT_REGISTRY;
    }

    @Override
    public Map<ICustomWirelessTerminalItem, ICustomWirelessTerminalItem> getNonCreativeToCreativeMap() {
        return WT_TO_CREATIVE;
    }

    @Override
    public int getNumRegisteredTerminals(boolean excludeWUT) {
        return this.getNonCreativeToCreativeMap().size() - (excludeWUT ? 1 : 0);
    }

    @Override
    public ItemStack getStackForHandler(Class<? extends ICustomWirelessTerminalItem> clazz, boolean creative, boolean fullyPower) {
        for (Map.Entry<ICustomWirelessTerminalItem, ICustomWirelessTerminalItem> entry : this.getNonCreativeToCreativeMap().entrySet()) {
            ICustomWirelessTerminalItem currentHandler = entry.getKey();
            if (!(currentHandler instanceof Item) || !currentHandler.getClass().equals(clazz)) continue;
            if (creative) {
                return new ItemStack((Item)entry.getValue());
            }
            ItemStack terminal = new ItemStack((Item)currentHandler);
            if (fullyPower) {
                ((AEBasePoweredItem)terminal.func_77973_b()).injectAEPower(terminal, (double)LibConfig.WT_MAX_POWER, Actionable.MODULATE);
            }
            return terminal;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public <T extends ICustomWirelessTerminalItem, C extends T> void registerWirelessTerminal(T wirelessTerminal, C creativeTerminal) {
        if (AE2WTLib.PROXY.getLoaderState() != LoaderState.PREINITIALIZATION) {
            LibLogger.warn("Wireless Terminals must be registered during PreInit!");
            return;
        }
        if (wirelessTerminal != null) {
            if (!(wirelessTerminal instanceof ItemWT)) {
                LibLogger.warn("Wireless terminal items must extend ItemWT.class");
                return;
            }
            if (!(wirelessTerminal instanceof ICustomWirelessTerminalItem)) {
                LibLogger.warn("Wireless terminal items must implement ICustomWirelessTerminalItem.class");
                return;
            }
            if (WT_REGISTRY.contains(wirelessTerminal)) {
                LibLogger.warn("Terminal " + wirelessTerminal.getClass() + " has already been registered!");
                return;
            }
            WT_TO_CREATIVE.put(wirelessTerminal, (ICustomWirelessTerminalItem)creativeTerminal);
            this.addNewRecipes(new ICustomWirelessTerminalItem[]{wirelessTerminal, creativeTerminal});
            this.getRegisteredTerminals().addAll(Lists.newArrayList((Object[])new ICustomWirelessTerminalItem[]{wirelessTerminal, creativeTerminal}));
            AE2WTLib.PROXY.registerCustomRenderer(wirelessTerminal);
            AE2WTLib.PROXY.registerCustomRenderer((IModelHolder)creativeTerminal);
        }
    }

    @Override
    public ICustomWirelessTerminalItem getCreativeVersion(ICustomWirelessTerminalItem nonCreativeTerminal) {
        if (nonCreativeTerminal.isCreative()) {
            return nonCreativeTerminal;
        }
        if (WT_TO_CREATIVE.containsKey(nonCreativeTerminal)) {
            return WT_TO_CREATIVE.get(nonCreativeTerminal);
        }
        return null;
    }

    @Override
    public ItemStack convertToCreative(ItemStack wirelessTerminal) {
        NBTTagCompound wtNBT;
        ICustomWirelessTerminalItem creativeHandler;
        ICustomWirelessTerminalItem handler;
        if (wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem && (handler = (ICustomWirelessTerminalItem)wirelessTerminal.func_77973_b()) instanceof Item && !handler.isCreative() && (creativeHandler = this.getCreativeVersion(handler)) instanceof Item && (wtNBT = wirelessTerminal.serializeNBT()).func_150297_b("id", 8)) {
            String regName = wtNBT.func_74779_i("id");
            if (((Item)handler).getRegistryName().toString().equals(regName)) {
                wtNBT.func_74778_a("id", ((Item)creativeHandler).getRegistryName().toString());
                return new ItemStack(wtNBT);
            }
        }
        return wirelessTerminal;
    }

    private void addNewRecipes(ICustomWirelessTerminalItem ... wirelessTerminals) {
        for (ICustomWirelessTerminalItem wirelessTerminal : wirelessTerminals) {
            if (wirelessTerminal.isCreative()) {
                return;
            }
            Item item = (Item)wirelessTerminal;
            ItemStack stack = new ItemStack(item);
            for (ICustomWirelessTerminalItem wth : this.getRegisteredTerminals()) {
                RecipeNewTerminal.addRecipe(stack, new ItemStack((Item)wth));
            }
        }
    }

    private static void registerTerminalWithAE2(IWirelessTermHandler wirelessTerminal) {
        if (wirelessTerminal instanceof ItemWT) {
            AEApi.instance().registries().wireless().registerWirelessHandler(wirelessTerminal);
            AEApi.instance().registries().charger().addChargeRate((Item)wirelessTerminal, (double)LibConfig.WT_MAX_POWER);
        }
    }

    public static void registerAllTerminalsWithAE2() {
        for (ICustomWirelessTerminalItem wirelessTerminal : WTApi.instance().getWirelessTerminalRegistry().getRegisteredTerminals()) {
            if (!(wirelessTerminal instanceof ItemWT)) continue;
            LibWTRegistry.registerTerminalWithAE2(wirelessTerminal);
        }
    }
}

