/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.preprocessor;

import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import java.util.HashSet;

public class LoaderPreprocessor
extends PreprocessorActionBase {
    private static final String PREPROCESSOR_NAME = "loader";
    private String[] loaderNames;

    public LoaderPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String substring = preprocessorLine.substring(7).trim();
        String[] arr = substring.split("\\s+");
        HashSet<String> set = new HashSet<String>();
        for (String s : arr) {
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            set.add(trim);
        }
        this.loaderNames = set.toArray(new String[set.size()]);
    }

    @Override
    public void executeActionOnFind(ScriptFile scriptFile) {
        scriptFile.setLoaderNames(this.loaderNames);
    }

    @Override
    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }
}

