/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoMushrooms;
import rtg.api.world.deco.DecoPumpkin;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPinusNigra;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaExtremeHills;

public class RealisticBiomeVanillaExtremeHillsEdge
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_76783_v;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaExtremeHillsEdge() {
        super(biome, RealisticBiomeBase.BeachType.STONE);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_FILLER_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new RealisticBiomeVanillaExtremeHills.RidgedExtremeHills(125.0f, 67.0f, 200.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaExtremeHillsEdge(this.getConfig(), RealisticBiomeVanillaExtremeHillsEdge.biome.field_76752_A, RealisticBiomeVanillaExtremeHillsEdge.biome.field_76753_B, Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 60.0f, -0.14f, 14.0f, 0.25f);
    }

    @Override
    public void initDecos() {
        TreeRTGPinusNigra nigraTree = new TreeRTGPinusNigra();
        nigraTree.setLogBlock(Blocks.field_150364_r.func_176223_P());
        nigraTree.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        nigraTree.setMinTrunkSize(18);
        nigraTree.setMaxTrunkSize(27);
        nigraTree.setMinCrownSize(7);
        nigraTree.setMaxCrownSize(10);
        this.addTree(nigraTree);
        DecoTree decoTrees = new DecoTree(nigraTree);
        decoTrees.setStrengthFactorForLoops(4.0f);
        decoTrees.setStrengthNoiseFactorXForLoops(true);
        decoTrees.getDistribution().setNoiseDivisor(100.0f);
        decoTrees.getDistribution().setNoiseFactor(6.0f);
        decoTrees.getDistribution().setNoiseAddend(0.8f);
        decoTrees.setTreeType(DecoTree.TreeType.RTG_TREE);
        decoTrees.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        decoTrees.setTreeConditionChance(24);
        decoTrees.setMaxY(100);
        this.addDeco(decoTrees);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree.setLogConditionChance(6);
        decoFallenTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(6);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.setMaxY(100);
        decoShrub.setLoopMultiplier(2.0f);
        this.addDeco(decoShrub);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150341_Y.func_176223_P());
        decoBoulder.setChance(12);
        decoBoulder.setMaxY(95);
        decoBoulder.setStrengthFactor(2.0f);
        this.addDeco(decoBoulder);
        DecoMushrooms decoMushrooms = new DecoMushrooms();
        decoMushrooms.setMaxY(90);
        decoMushrooms.setRandomFloat(3.0f);
        this.addDeco(decoMushrooms);
        DecoPumpkin decoPumpkin = new DecoPumpkin();
        decoPumpkin.setMaxY(90);
        decoPumpkin.setRandomFloat(20.0f);
        this.addDeco(decoPumpkin);
    }

    public static class SurfaceVanillaExtremeHillsEdge
    extends SurfaceBase {
        private IBlockState mixBlockTop;
        private IBlockState mixBlockFill;
        private float width;
        private float height;
        private float smallW;
        private float smallS;

        public SurfaceVanillaExtremeHillsEdge(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFill, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.mixBlockTop = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mixTop);
            this.mixBlockFill = this.getConfigBlock(config.SURFACE_MIX_FILLER_BLOCK.get(), mixFill);
            this.width = mixWidth;
            this.height = mixHeight;
            this.smallW = smallWidth;
            this.smallS = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) + simplex.noise2f((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlockTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.mixBlockFill);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaExtremeHillsEdge
    extends TerrainBase {
        private float start;
        private float height;
        private float base;
        private float width;

        public TerrainVanillaExtremeHillsEdge(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaExtremeHillsEdge.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, 10.0f);
        }
    }
}

