/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.rockhounding;

import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.gen.RTGChunkGenSettings;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.rockhounding.RealisticBiomeRHBase;

public class RealisticBiomeRHWhiteSands
extends RealisticBiomeRHBase {
    public RealisticBiomeRHWhiteSands(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaDesert();
    }

    public static class TerrainVanillaDesert
    extends TerrainBase {
        public TerrainVanillaDesert() {
            super(64.0f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            RTGChunkGenSettings settings = rtgWorld.getGeneratorSettings();
            float duneHeight = this.minDuneHeight + (float)settings.sandDuneHeight;
            float stPitch = 200.0f;
            float stFactor = duneHeight *= (1.0f + rtgWorld.simplexInstance(2).noise2f((float)x / 330.0f, (float)y / 330.0f)) / 2.0f;
            float hPitch = 70.0f;
            float hDivisor = 40.0f;
            return TerrainVanillaDesert.terrainPolar(x, y, rtgWorld, river, stPitch, stFactor, hPitch, hDivisor, this.base) + TerrainVanillaDesert.groundNoise(x, y, 1.0f, rtgWorld);
        }
    }
}

