/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.realworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.BumpyHillsEffect;
import rtg.world.biome.realistic.realworld.RealisticBiomeRWBase;

public class RealisticBiomeRWBlueOakForest
extends RealisticBiomeRWBase {
    public RealisticBiomeRWBlueOakForest(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainRWBlueOakForest();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceRWBlueOakForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, BlockUtil.getStateDirt(BlockDirt.DirtType.PODZOL), 0.15f);
    }

    public static class SurfaceRWBlueOakForest
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mix;
        private float mixHeight;

        public SurfaceRWBlueOakForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mixBlock, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mix = mixBlock;
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mix);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainRWBlueOakForest
    extends TerrainBase {
        private float baseHeight = 64.0f;
        private float hillStrength = 50.0f;
        private BumpyHillsEffect hillEffect = new BumpyHillsEffect();
        private float hillWidth = 60.0f;
        private float hillBumpyness = 10.0f;
        private float hillBumpynessWidth = 20.0f;

        public TerrainRWBlueOakForest() {
            this.hillEffect.hillHeight = this.hillStrength;
            this.hillEffect.hillWavelength = this.hillWidth;
            this.hillEffect.spikeHeight = this.hillBumpyness;
            this.hillEffect.spikeWavelength = this.hillBumpynessWidth;
        }

        public TerrainRWBlueOakForest(float bh, float hs) {
            this();
            this.baseHeight = bh;
            this.hillStrength = hs;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainRWBlueOakForest.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            float m = this.hillEffect.added(rtgWorld, x, y);
            return TerrainRWBlueOakForest.riverized(this.baseHeight, river) + (this.groundNoise + m) * river;
        }
    }
}

