/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoFlowersRTG;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionBase;
import rtg.api.world.deco.helper.DecoHelper5050;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPiceaSitchensis;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPWoodland
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.woodland.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPWoodland() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPWoodland(10.0f, 25.0f, 72.0f, 120.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPWoodland(this.getConfig(), RealisticBiomeBOPWoodland.biome.field_76752_A, RealisticBiomeBOPWoodland.biome.field_76753_B);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionWoodland(this.getConfig()));
    }

    private static class DecoCollectionWoodland
    extends DecoCollectionBase {
        private DecoTree.Distribution forestDistribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
        private float tallMin = -1.0f;
        private float tallMax = 3.0f;
        private float short1Min = -3.0f;
        private float short1Max = -1.0f;

        DecoCollectionWoodland(BiomeConfig config) {
            super(config);
            this.addDeco(this.tallTrees(this.tallMin, this.tallMax)).addDeco(this.shortTrees(this.short1Min, this.short1Max)).addDeco(this.logs(), config.ALLOW_LOGS.get()).addDeco(this.shrubsOak()).addDeco(this.shrubsSpruce()).addDeco(this.flowers());
        }

        private DecoHelper5050 tallTrees(float noiseMin, float noiseMax) {
            return new DecoHelper5050(this.tallPineTrees(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P(), noiseMin, noiseMax), this.tallPineTrees(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE), BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE), noiseMin, noiseMax));
        }

        private DecoTree tallPineTrees(IBlockState log, IBlockState leaves, float noiseMin, float noiseMax) {
            TreeRTGPinusPonderosa pinusPonderosa = new TreeRTGPinusPonderosa();
            pinusPonderosa.setLogBlock(log);
            pinusPonderosa.setLeavesBlock(leaves);
            pinusPonderosa.setMinTrunkSize(6);
            pinusPonderosa.setMaxTrunkSize(10);
            pinusPonderosa.setMinCrownSize(8);
            pinusPonderosa.setMaxCrownSize(20);
            this.addTree(pinusPonderosa);
            return new DecoTree(pinusPonderosa).setStrengthFactorForLoops(6.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setDistribution(this.forestDistribution).setTreeCondition(DecoTree.TreeCondition.NOISE_BETWEEN_AND_RANDOM_CHANCE).setTreeConditionNoise(noiseMin).setTreeConditionNoise2(noiseMax).setTreeConditionChance(1).setMaxY(85);
        }

        private DecoHelper5050 shortTrees(float noiseMin, float noiseMax) {
            return new DecoHelper5050(this.shortPineTrees(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P(), noiseMin, noiseMax), this.shortPineTrees(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE), BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE), noiseMin, noiseMax));
        }

        private DecoTree shortPineTrees(IBlockState log, IBlockState leaves, float noiseMin, float noiseMax) {
            TreeRTG piceaSitchensis = new TreeRTGPiceaSitchensis().setLogBlock(log).setLeavesBlock(leaves).setMinTrunkSize(4).setMaxTrunkSize(9).setMinCrownSize(6).setMaxCrownSize(13);
            this.addTree(piceaSitchensis);
            return new DecoTree(piceaSitchensis).setStrengthFactorForLoops(6.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setDistribution(this.forestDistribution).setTreeCondition(DecoTree.TreeCondition.NOISE_BETWEEN_AND_RANDOM_CHANCE).setTreeConditionNoise(noiseMin).setTreeConditionNoise2(noiseMax).setTreeConditionChance(1).setMaxY(85);
        }

        private DecoHelper5050 logs() {
            return new DecoHelper5050(this.oakLogs(), this.spruceLogs());
        }

        private DecoFallenTree oakLogs() {
            return new DecoFallenTree().setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE).setLogConditionChance(10).setMaxY(80).setLogBlock(Blocks.field_150364_r.func_176223_P()).setLeavesBlock(Blocks.field_150362_t.func_176223_P()).setMinSize(3).setMaxSize(6);
        }

        private DecoFallenTree spruceLogs() {
            return new DecoFallenTree().setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE).setLogConditionChance(24).setMaxY(80).setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE)).setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE)).setMinSize(3).setMaxSize(6);
        }

        private DecoShrub shrubsOak() {
            return new DecoShrub().setMaxY(140).setLoopMultiplier(4.0f).setChance(3);
        }

        private DecoShrub shrubsSpruce() {
            return new DecoShrub().setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE)).setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE)).setMaxY(140).setLoopMultiplier(4.0f).setChance(9);
        }

        private DecoFlowersRTG flowers() {
            return new DecoFlowersRTG().addFlowers(BlockFlower.EnumFlowerType.POPPY, BlockFlower.EnumFlowerType.BLUE_ORCHID, BlockFlower.EnumFlowerType.ALLIUM, BlockFlower.EnumFlowerType.HOUSTONIA, BlockFlower.EnumFlowerType.RED_TULIP, BlockFlower.EnumFlowerType.ORANGE_TULIP, BlockFlower.EnumFlowerType.WHITE_TULIP, BlockFlower.EnumFlowerType.PINK_TULIP, BlockFlower.EnumFlowerType.OXEYE_DAISY, BlockFlower.EnumFlowerType.DANDELION).setMaxY(128).setStrengthFactor(6.0f);
        }
    }

    public static class SurfaceBOPWoodland
    extends SurfaceBase {
        public SurfaceBOPWoodland(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPWoodland
    extends TerrainBase {
        private float start;
        private float height;
        private float width;

        public TerrainBOPWoodland(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPWoodland.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, this.base - 62.0f);
        }
    }
}

