/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenBlob;

public class DecoBoulder
extends DecoBase {
    private IBlockState boulderBlock;
    private float strengthFactor;
    private int minY;
    private int maxY;
    private HeightType heightType;
    private int chance;
    private boolean water;
    private List<Block> validGroundBlocks;

    public DecoBoulder() {
        this.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        this.setStrengthFactor(2.0f);
        this.setMinY(60);
        this.setMaxY(255);
        this.setHeightType(HeightType.GET_HEIGHT_VALUE);
        this.setChance(10);
        this.water = true;
        this.validGroundBlocks = Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150354_m);
        this.addDecoTypes(DecoBase.DecoType.BOULDER);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if (rtgWorld.getGeneratorSettings().useBoulders && TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i = 0;
            while ((float)i < this.strengthFactor) {
                int y;
                BlockPos pos = DecoBoulder.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
                switch (this.heightType) {
                    case NEXT_INT: {
                        y = DecoBoulder.getRangedRandom(rand, this.minY, this.maxY);
                        break;
                    }
                    default: {
                        y = rtgWorld.world().func_175645_m(pos).func_177956_o();
                    }
                }
                if (y >= this.minY && y <= this.maxY && rand.nextInt(this.chance) == 0 && (!hasVillage || BlockUtil.checkAreaMaterials(BlockUtil.MatchType.ALL_IGNORE_REPLACEABLE, rtgWorld.world(), pos.func_177981_b(y), 2, new Material[0]))) {
                    new WorldGenBlob(this.boulderBlock, 0, this.validGroundBlocks, this.water).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                }
                ++i;
            }
        }
    }

    public IBlockState getBoulderBlock() {
        return this.boulderBlock;
    }

    public DecoBoulder setBoulderBlock(IBlockState boulderBlock) {
        this.boulderBlock = boulderBlock;
        return this;
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoBoulder setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoBoulder setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoBoulder setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoBoulder setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public boolean isWater() {
        return this.water;
    }

    public DecoBoulder setWater(boolean water) {
        this.water = water;
        return this;
    }

    public HeightType getHeightType() {
        return this.heightType;
    }

    public DecoBoulder setHeightType(HeightType heightType) {
        this.heightType = heightType;
        return this;
    }

    public List<Block> getValidGroundBlocks() {
        return Collections.unmodifiableList(this.validGroundBlocks);
    }

    public DecoBoulder setValidGroundBlocks(ArrayList<Block> validGroundBlocks) {
        this.validGroundBlocks = Collections.unmodifiableList(validGroundBlocks);
        return this;
    }

    @Deprecated
    public static enum HeightType {
        NEXT_INT,
        GET_HEIGHT_VALUE;

    }
}

