/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.biome.Biome;
import rtg.api.util.storage.IndexedMap;
import rtg.api.world.biome.IRealisticBiome;

public final class BiomeMap
implements IndexedMap.LimitedIndexedMap.IntegerLIMap<Biome, IRealisticBiome> {
    private static final long serialVersionUID = -5276712268351774212L;
    private final transient IndexedMap.IndexMapEntry<Biome, IRealisticBiome, Integer>[] entries = new IndexedMap.IndexMapEntry[this.getCapacity()];
    private boolean locked = false;

    public void addBiomes(IRealisticBiome ... rbiomes) {
        Arrays.stream(rbiomes).forEach((? super T b) -> this.put(b.baseBiome(), (IRealisticBiome)b));
    }

    @Override
    public int getCapacity() {
        return 256;
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean areEntriesMutable() {
        return false;
    }

    @Override
    public Function<Biome, Integer> getIndexer() {
        return Biome::func_185362_a;
    }

    @Override
    public Integer getIndex(@Nonnull Biome key) {
        return this.getIndexer().apply(key);
    }

    @Override
    @Nullable
    public Biome getKeyAt(@Nonnull Integer index) {
        if (this.checkBounds(index)) {
            return null;
        }
        return this.entries[index] != null ? (Biome)this.entries[index].getKey() : null;
    }

    @Override
    @Nullable
    public IRealisticBiome getValueAt(@Nonnull Integer index) {
        if (this.checkBounds(index)) {
            return null;
        }
        return this.entries[index] != null ? (IRealisticBiome)this.entries[index].getValue() : null;
    }

    @Override
    @Nullable
    public IRealisticBiome putAt(@Nonnull Biome key, @Nonnull IRealisticBiome value, Integer index) {
        if (this.locked) {
            return null;
        }
        if (this.checkBounds(index)) {
            return null;
        }
        if (this.isMutable()) {
            Objects.requireNonNull(key, "Key cannot be null");
            Objects.requireNonNull(value, "Value cannot be null");
            return this.insert(this.getNewEntry(key, value), index);
        }
        if (this.isStrict()) {
            throw new IllegalArgumentException("Immutable data");
        }
        return null;
    }

    @Override
    @Nullable
    public IRealisticBiome remove(@Nonnull Integer index) {
        if (this.locked) {
            return null;
        }
        IRealisticBiome oldValue = this.getValueAt(index);
        this.entries[index.intValue()] = null;
        return oldValue;
    }

    @Nullable
    private IRealisticBiome insert(@Nonnull IndexedMap.IndexMapEntry<Biome, IRealisticBiome, Integer> newEntry, int index) {
        IndexedMap.IndexMapEntry<Biome, IRealisticBiome, Integer> oldValue = this.entries[index];
        this.entries[index] = newEntry;
        return oldValue != null ? (IRealisticBiome)oldValue.getValue() : null;
    }

    @Override
    public int size() {
        return (int)Arrays.stream(this.entries).filter(Objects::nonNull).count();
    }

    @Override
    public boolean isEmpty() {
        return Arrays.stream(this.entries).noneMatch(Objects::nonNull);
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        return Arrays.stream(this.entries).anyMatch(e -> e != null && ((Biome)e.getKey()).equals(key));
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        return Arrays.stream(this.entries).anyMatch(e -> e != null && ((IRealisticBiome)e.getValue()).equals(value));
    }

    @Override
    @Nullable
    public IRealisticBiome get(@Nonnull Object key) {
        return Arrays.stream(this.entries).filter(e -> Objects.nonNull(e) && ((Biome)e.getKey()).equals(key)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    @Nullable
    public IRealisticBiome put(@Nonnull Biome key, @Nonnull IRealisticBiome value) {
        if (this.locked) {
            return null;
        }
        return this.putAt(key, value, this.getIndexer().apply(key));
    }

    @Override
    @Nullable
    public IRealisticBiome remove(@Nonnull Object key) {
        if (this.locked) {
            return null;
        }
        for (int i = 0; i < this.entries.length; ++i) {
            if (!Objects.equals(this.getKeyAt(i), key)) continue;
            return this.remove(i);
        }
        return null;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Biome, ? extends IRealisticBiome> m) {
        if (this.locked) {
            return;
        }
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        if (this.locked) {
            return;
        }
        Arrays.fill(this.entries, null);
    }

    @Override
    @Nonnull
    public Set<Biome> keySet() {
        return Arrays.stream(this.entries).filter(Objects::nonNull).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    @Nonnull
    public Collection<IRealisticBiome> values() {
        return Arrays.stream(this.entries).filter(Objects::nonNull).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<Biome, IRealisticBiome>> entrySet() {
        return Arrays.stream(this.entries).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiomeMap map = (BiomeMap)o;
        return this.getCapacity() == map.getCapacity() && Arrays.equals(this.entries, map.entries);
    }

    @Override
    public int hashCode() {
        return 31 * this.getCapacity() + Arrays.hashCode(this.entries);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.getClass().getSimpleName()).append("[");
        boolean first = true;
        for (Map.Entry<Biome, IRealisticBiome> e : this.entrySet()) {
            if (first) {
                ret.append("{");
            } else {
                ret.append(",{");
            }
            ret.append(e.toString()).append("}");
            first = false;
        }
        return ret.append("]").toString();
    }

    public Stream<Map.Entry<Biome, IRealisticBiome>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.entrySet(), 0), false);
    }

    private IndexedMap.IndexMapEntry<Biome, IRealisticBiome, Integer> getNewEntry(@Nonnull Biome key, @Nonnull IRealisticBiome value) {
        if (this.areEntriesMutable()) {
            return new IndexedMap.IndexMapEntry.IndexEntryBase.SimpleMutableIndexEntry<Biome, IRealisticBiome, Comparable>(key, value, this.getIndexer().apply(key));
        }
        return new IndexedMap.IndexMapEntry.IndexEntryBase.SimpleImmutableIndexEntry<Biome, IRealisticBiome, Comparable>(key, value, this.getIndexer().apply(key));
    }

    public void setLocked() {
        this.locked = true;
    }
}

