/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.noise;

import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexNoise;

public class OpenSimplexNoise
implements SimplexNoise {
    static final double[] GRADIENTS_2D;
    static final double[] GRADIENTS_SPH2;
    static final double[] GRADIENTS_3D;
    private static final double STRETCH_2D = -0.211324865405187;
    private static final double SQUISH_2D = 0.366025403784439;
    private static final double STRETCH_3D = -0.16666666666666666;
    private static final double SQUISH_3D = 0.3333333333333333;
    private static final LatticePoint2D[] LOOKUP_2D;
    private static final Contribution3D[] LOOKUP_3D;
    private int[] perm = new int[1024];
    private int[] perm2D = new int[1024];
    private int[] perm2D_sph2 = new int[1024];
    private int[] perm3D = new int[1024];

    public OpenSimplexNoise(long seed) {
        int i;
        int[] source = new int[1024];
        for (i = 0; i < 1024; ++i) {
            source[i] = i;
        }
        for (i = 1023; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.perm2D[i] = this.perm[i] % 12 * 2;
            this.perm2D_sph2[i] = this.perm[i] / 12 % 12 * 2;
            this.perm3D[i] = this.perm[i] % 48 * 3;
            source[r] = source[i];
        }
    }

    private static int fastFloor(double d) {
        int n;
        int i = (int)d;
        return d < (double)n ? i - 1 : i;
    }

    @Override
    public float noise2f(float x, float y) {
        return (float)this.noise2d(x, y);
    }

    @Override
    public float noise3f(float x, float y, float z) {
        return (float)this.noise3d(x, y, z);
    }

    @Override
    public double noise2d(double x, double y) {
        double value = 0.0;
        double s = -0.211324865405187 * (x + y);
        double xs = x + s;
        double ys = y + s;
        int xsb = OpenSimplexNoise.fastFloor(xs);
        int ysb = OpenSimplexNoise.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(ysi - xsi + 1.0);
        int index = a << 2 | (int)(xsi + ysi / 2.0 + (double)a / 2.0) << 3 | (int)(ysi + xsi / 2.0 + 0.5 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * 0.366025403784439;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D lattice = LOOKUP_2D[index + i];
            double dx = xi + lattice.getDx();
            double dy = yi + lattice.getDy();
            double attn = 2.0 - Math.pow(dx, 2.0) - Math.pow(dy, 2.0);
            if (attn <= 0.0) continue;
            int pxm = xsb + lattice.getXsv() & 0x3FF;
            int pym = ysb + lattice.getYsv() & 0x3FF;
            int gi = this.perm2D[this.perm[pxm] ^ pym];
            double extrp = GRADIENTS_2D[gi] * dx + GRADIENTS_2D[gi + 1] * dy;
            value += Math.pow(attn, 4.0) * extrp;
        }
        return value;
    }

    @Override
    public double noise3d(double x, double y, double z) {
        double stretchOffset = (x + y + z) * -0.16666666666666666;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        double zs = z + stretchOffset;
        int xsb = OpenSimplexNoise.fastFloor(xs);
        int ysb = OpenSimplexNoise.fastFloor(ys);
        int zsb = OpenSimplexNoise.fastFloor(zs);
        double squishOffset = (double)(xsb + ysb + zsb) * 0.3333333333333333;
        double dx0 = x - ((double)xsb + squishOffset);
        double dy0 = y - ((double)ysb + squishOffset);
        double dz0 = z - ((double)zsb + squishOffset);
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double zins = zs - (double)zsb;
        double inSum = xins + yins + zins;
        int hash = (int)(yins - zins + 1.0) | (int)(xins - yins + 1.0) << 1 | (int)(xins - zins + 1.0) << 2 | (int)inSum << 3 | (int)(inSum + zins) << 5 | (int)(inSum + yins) << 7 | (int)(inSum + xins) << 9;
        Contribution3D c = LOOKUP_3D[hash];
        double value = 0.0;
        while (c != null) {
            double dz;
            double dy;
            double dx = dx0 + c.getDx();
            double attn = 2.0 - dx * dx - (dy = dy0 + c.getDy()) * dy - (dz = dz0 + c.getDz()) * dz;
            if (attn > 0.0) {
                int px = xsb + c.getXsb();
                int py = ysb + c.getYsb();
                int pz = zsb + c.getZsb();
                int i = this.perm3D[(this.perm[(this.perm[px & 0x3FF] ^ py) & 0x3FF] ^ pz) & 0x3FF];
                double valuePart = GRADIENTS_3D[i] * dx + GRADIENTS_3D[i + 1] * dy + GRADIENTS_3D[i + 2] * dz;
                value += Math.pow(attn, 4.0) * valuePart;
            }
            c = c.getNext();
        }
        return value;
    }

    @Override
    public void multiEval2D(double x, double y, ISimplexData2D data) {
        double s = -0.211324865405187 * (x + y);
        double xs = x + s;
        double ys = y + s;
        int xsb = OpenSimplexNoise.fastFloor(xs);
        int ysb = OpenSimplexNoise.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(ysi - xsi + 1.0);
        int index = a << 2 | (int)(xsi + ysi / 2.0 + (double)a / 2.0) << 3 | (int)(ysi + xsi / 2.0 + 0.5 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * 0.366025403784439;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        data.clear();
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D lattice = LOOKUP_2D[index + i];
            double dx = xi + lattice.getDx();
            double dy = yi + lattice.getDy();
            double attn = 2.0 - Math.pow(dx, 2.0) - Math.pow(dy, 2.0);
            if (attn <= 0.0) continue;
            int pxm = xsb + lattice.getXsv() & 0x3FF;
            int pym = ysb + lattice.getYsv() & 0x3FF;
            int gi_p = this.perm[pxm] ^ pym;
            int gi = this.perm2D[gi_p];
            double gx = GRADIENTS_2D[gi];
            double gy = GRADIENTS_2D[gi + 1];
            double extrp = gx * dx + gy * dy;
            int gi_sph2 = this.perm2D_sph2[gi_p];
            data.request().apply(attn, extrp, gx, gy, gi_sph2, dx, dy);
        }
    }

    static {
        int i;
        GRADIENTS_2D = new double[]{0.114251372530929, 0.065963060686016, 0.131926121372032, 0.0, 0.114251372530929, -0.065963060686016, 0.065963060686016, -0.114251372530929, 0.0, -0.131926121372032, -0.065963060686016, -0.114251372530929, -0.114251372530929, -0.065963060686016, -0.131926121372032, -0.0, -0.114251372530929, 0.065963060686016, -0.065963060686016, 0.114251372530929, -0.0, 0.131926121372032, 0.065963060686016, 0.114251372530929};
        GRADIENTS_SPH2 = new double[]{0.0, 1.0, 0.5, 0.866025403784439, 0.866025403784439, 0.5, 1.0, 0.0, 0.866025403784439, -0.5, 0.5, -0.866025403784439, 0.0, -1.0, -0.5, -0.866025403784439, -0.866025403784439, -0.5, -1.0, 0.0, -0.866025403784439, 0.5, -0.5, 0.866025403784439};
        GRADIENTS_3D = new double[]{-0.00919201927982, 0.061948581592974, 0.10551312462631, 0.061948581592974, -0.00919201927982, 0.10551312462631, 0.052339395980958, 0.052339395980958, 0.097858646551677, 0.002784312704445, 0.002784312704445, 0.122636188189934, -0.00919201927982, 0.10551312462631, 0.061948581592974, 0.061948581592974, 0.10551312462631, -0.00919201927982, 0.052339395980958, 0.097858646551677, 0.052339395980958, 0.002784312704445, 0.122636188189934, 0.002784312704445, 0.10551312462631, -0.00919201927982, 0.061948581592974, 0.10551312462631, 0.061948581592974, -0.00919201927982, 0.097858646551677, 0.052339395980958, 0.052339395980958, 0.122636188189934, 0.002784312704445, 0.002784312704445, -0.0672780766576, 0.090991610281865, 0.047427067248529, -0.090991610281865, 0.0672780766576, -0.047427067248529, -0.057908021389848, 0.107463104666361, -0.012388770819128, -0.107463104666361, 0.057908021389848, 0.012388770819128, -0.0672780766576, 0.047427067248529, 0.090991610281865, -0.090991610281865, -0.047427067248529, 0.0672780766576, -0.057908021389848, -0.012388770819128, 0.107463104666361, -0.107463104666361, 0.012388770819128, 0.057908021389848, 0.047427067248529, -0.0672780766576, 0.090991610281865, -0.047427067248529, -0.090991610281865, 0.0672780766576, -0.012388770819128, -0.057908021389848, 0.107463104666361, 0.012388770819128, -0.107463104666361, 0.057908021389848, 0.0672780766576, -0.090991610281865, -0.047427067248529, 0.090991610281865, -0.0672780766576, 0.047427067248529, 0.107463104666361, -0.057908021389848, -0.012388770819128, 0.057908021389848, -0.107463104666361, 0.012388770819128, 0.0672780766576, -0.047427067248529, -0.090991610281865, 0.090991610281865, 0.047427067248529, -0.0672780766576, 0.107463104666361, -0.012388770819128, -0.057908021389848, 0.057908021389848, 0.012388770819128, -0.107463104666361, -0.047427067248529, 0.0672780766576, -0.090991610281865, 0.047427067248529, 0.090991610281865, -0.0672780766576, -0.012388770819128, 0.107463104666361, -0.057908021389848, 0.012388770819128, 0.057908021389848, -0.107463104666361, 0.00919201927982, -0.061948581592974, -0.10551312462631, -0.061948581592974, 0.00919201927982, -0.10551312462631, -0.002784312704445, -0.002784312704445, -0.122636188189934, -0.052339395980958, -0.052339395980958, -0.097858646551677, 0.00919201927982, -0.10551312462631, -0.061948581592974, -0.061948581592974, -0.10551312462631, 0.00919201927982, -0.002784312704445, -0.122636188189934, -0.002784312704445, -0.052339395980958, -0.097858646551677, -0.052339395980958, -0.10551312462631, 0.00919201927982, -0.061948581592974, -0.10551312462631, -0.061948581592974, 0.00919201927982, -0.122636188189934, -0.002784312704445, -0.002784312704445, -0.097858646551677, -0.052339395980958, -0.052339395980958};
        LOOKUP_2D = new LatticePoint2D[32];
        for (int i2 = 0; i2 < 8; ++i2) {
            int j2;
            int i22;
            int j1;
            int i1;
            if ((i2 & 1) == 0) {
                if ((i2 & 2) == 0) {
                    i1 = 0;
                    j1 = 0;
                } else {
                    i1 = 2;
                    j1 = 0;
                }
                if ((i2 & 4) == 0) {
                    i22 = 1;
                    j2 = -1;
                } else {
                    i22 = 1;
                    j2 = 1;
                }
            } else {
                if ((i2 & 2) == 0) {
                    i1 = -1;
                    j1 = 1;
                } else {
                    i1 = 1;
                    j1 = 1;
                }
                if ((i2 & 4) == 0) {
                    i22 = 0;
                    j2 = 0;
                } else {
                    i22 = 0;
                    j2 = 2;
                }
            }
            OpenSimplexNoise.LOOKUP_2D[i2 * 4] = new LatticePoint2D(1, 0);
            OpenSimplexNoise.LOOKUP_2D[i2 * 4 + 1] = new LatticePoint2D(0, 1);
            OpenSimplexNoise.LOOKUP_2D[i2 * 4 + 2] = new LatticePoint2D(i1, j1);
            OpenSimplexNoise.LOOKUP_2D[i2 * 4 + 3] = new LatticePoint2D(i22, j2);
        }
        int[][] base3D = new int[][]{{0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1}, {2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1, 3, 1, 1, 1}, {1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 0, 2, 1, 0, 1, 2, 0, 1, 1}};
        int[] p3D = new int[]{0, 0, 1, -1, 0, 0, 1, 0, -1, 0, 0, -1, 1, 0, 0, 0, 1, -1, 0, 0, -1, 0, 1, 0, 0, -1, 1, 0, 2, 1, 1, 0, 1, 1, 1, -1, 0, 2, 1, 0, 1, 1, 1, -1, 1, 0, 2, 0, 1, 1, 1, -1, 1, 1, 1, 3, 2, 1, 0, 3, 1, 2, 0, 1, 3, 2, 0, 1, 3, 1, 0, 2, 1, 3, 0, 2, 1, 3, 0, 1, 2, 1, 1, 1, 0, 0, 2, 2, 0, 0, 1, 1, 0, 1, 0, 2, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, -1, 1, 2, 0, 0, 0, 0, 1, -1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, -1, 2, 3, 1, 1, 1, 2, 0, 0, 2, 2, 3, 1, 1, 1, 2, 2, 0, 0, 2, 3, 1, 1, 1, 2, 0, 2, 0, 2, 1, 1, -1, 1, 2, 0, 0, 2, 2, 1, 1, -1, 1, 2, 2, 0, 0, 2, 1, -1, 1, 1, 2, 0, 0, 2, 2, 1, -1, 1, 1, 2, 0, 2, 0, 2, 1, 1, 1, -1, 2, 2, 0, 0, 2, 1, 1, 1, -1, 2, 0, 2, 0};
        int[] lookupPairs3D = new int[]{0, 2, 1, 1, 2, 2, 5, 1, 6, 0, 7, 0, 32, 2, 34, 2, 129, 1, 133, 1, 160, 5, 161, 5, 518, 0, 519, 0, 546, 4, 550, 4, 645, 3, 647, 3, 672, 5, 673, 5, 674, 4, 677, 3, 678, 4, 679, 3, 680, 13, 681, 13, 682, 12, 685, 14, 686, 12, 687, 14, 712, 20, 714, 18, 809, 21, 813, 23, 840, 20, 841, 21, 1198, 19, 1199, 22, 1226, 18, 1230, 19, 1325, 23, 1327, 22, 1352, 15, 1353, 17, 1354, 15, 1357, 17, 1358, 16, 1359, 16, 1360, 11, 1361, 10, 1362, 11, 1365, 10, 1366, 9, 1367, 9, 1392, 11, 1394, 11, 1489, 10, 1493, 10, 1520, 8, 1521, 8, 1878, 9, 1879, 9, 1906, 7, 1910, 7, 2005, 6, 2007, 6, 2032, 8, 2033, 8, 2034, 7, 2037, 6, 2038, 7, 2039, 6};
        Contribution3D[] contributions3D = new Contribution3D[p3D.length / 9];
        for (i = 0; i < p3D.length; i += 9) {
            int[] baseSet = base3D[p3D[i]];
            Contribution3D previous = null;
            Contribution3D current = null;
            for (int j = 0; j < baseSet.length; j += 4) {
                current = new Contribution3D(baseSet[j], baseSet[j + 1], baseSet[j + 2], baseSet[j + 3]);
                if (previous == null) {
                    contributions3D[i / 9] = current;
                } else {
                    previous.setNext(current);
                }
                previous = current;
            }
            if (current == null) continue;
            current.setNext(new Contribution3D(p3D[i + 1], p3D[i + 2], p3D[i + 3], p3D[i + 4]));
            current.getNext().setNext(new Contribution3D(p3D[i + 5], p3D[i + 6], p3D[i + 7], p3D[i + 8]));
        }
        LOOKUP_3D = new Contribution3D[2048];
        for (i = 0; i < lookupPairs3D.length; i += 2) {
            OpenSimplexNoise.LOOKUP_3D[lookupPairs3D[i]] = contributions3D[lookupPairs3D[i + 1]];
        }
    }

    private static final class Contribution3D {
        private int xsb;
        private int ysb;
        private int zsb;
        private double dx;
        private double dy;
        private double dz;
        private Contribution3D next;

        private Contribution3D(double multiplier, int xsb, int ysb, int zsb) {
            this.xsb = xsb;
            this.ysb = ysb;
            this.zsb = zsb;
            this.dx = (double)(-xsb) - multiplier * 0.3333333333333333;
            this.dy = (double)(-ysb) - multiplier * 0.3333333333333333;
            this.dz = (double)(-zsb) - multiplier * 0.3333333333333333;
        }

        private Contribution3D getNext() {
            return this.next;
        }

        private void setNext(Contribution3D next) {
            this.next = next;
        }

        private double getDx() {
            return this.dx;
        }

        private double getDy() {
            return this.dy;
        }

        private double getDz() {
            return this.dz;
        }

        private int getXsb() {
            return this.xsb;
        }

        private int getYsb() {
            return this.ysb;
        }

        private int getZsb() {
            return this.zsb;
        }
    }

    private static final class LatticePoint2D {
        private int xsv;
        private int ysv;
        private double dx;
        private double dy;

        private LatticePoint2D(int xsv, int ysv) {
            this.xsv = xsv;
            this.ysv = ysv;
            this.dx = (double)(-xsv) - (double)(xsv + ysv) * 0.366025403784439;
            this.dy = (double)(-ysv) - (double)(xsv + ysv) * 0.366025403784439;
        }

        public int getXsv() {
            return this.xsv;
        }

        public int getYsv() {
            return this.ysv;
        }

        public double getDx() {
            return this.dx;
        }

        public double getDy() {
            return this.dy;
        }
    }
}

