/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.CustomGradient;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.TileMultipart;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.part.FluidTranslocatorPart;
import codechicken.translocators.part.ItemTranslocatorPart;
import codechicken.translocators.part.TranslocatorPart;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class RenderTranslocator {
    public static Vector3[] sidePos = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};
    public static Vector3[] sideVec = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    private static CCModel[] plates = new CCModel[6];
    private static CCModel insert;
    private static CustomGradient gradient;

    public static void renderStatic(CCRenderState ccrs, TranslocatorPart p, Vector3 pos) {
        Vector3 trans = pos.copy().add(Vector3.center);
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[p.getTType()][p.getIconIndex()]);
        ccrs.reset();
        ccrs.setBrightness((IBlockAccess)p.world(), p.pos());
        plates[p.side].render(ccrs, new IVertexOperation[]{trans.translation(), i_trans});
    }

    public static void renderFast(CCRenderState ccrs, TranslocatorPart p, Vector3 pos, float delta) {
        double insertpos = MathHelper.interpolate((double)p.b_insertpos, (double)p.a_insertpos, (double)delta);
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[p.getTType()][p.getIconIndex()]);
        Matrix4 matrix = new Matrix4().translate(pos.copy().add(Vector3.center)).apply(Rotation.sideRotations[p.side]).translate(new Vector3(0.0, -0.5, 0.0)).scale(new Vector3(1.0, insertpos * 2.0 / 3.0 + 0.3333333333333333, 1.0));
        ccrs.reset();
        ccrs.setBrightness((IBlockAccess)p.world(), p.pos());
        insert.render(ccrs, new IVertexOperation[]{PlanarLightModel.standardLightModel, matrix, i_trans});
    }

    public static void renderItem(ItemStack stack) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181712_l);
        IconTransformation i_trans = new IconTransformation(TranslocatorTextures.TEXTURES[stack.func_77960_j()][0]);
        Vector3 v_trans = Vector3.center.copy().add(0.0, 0.0, 0.5);
        Translation trans = v_trans.translation();
        Matrix4 i_matrix = new Matrix4().translate(v_trans).apply(Rotation.sideRotations[2]).translate(new Vector3(0.0, -0.5, 0.0)).scale(new Vector3(1.0, 1.0, 1.0));
        plates[2].render(ccrs, new IVertexOperation[]{trans, i_trans});
        insert.render(ccrs, new IVertexOperation[]{i_matrix, i_trans});
        ccrs.draw();
    }

    public static void renderDynamic(TranslocatorPart p, Vector3 pos, float delta) {
        CCRenderState ccrs = CCRenderState.instance();
        double time = ClientUtils.getRenderTime();
        TileMultipart tile = p.tile();
        if (p.a_eject) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            TextureUtils.changeTexture((String)"translocators:textures/fx/particle.png");
            ccrs.startDrawing(7, DefaultVertexFormats.field_181709_i);
            for (int dst = 0; dst < 6; ++dst) {
                TranslocatorPart p_dst;
                if (dst == p.side || !p.canConnect(dst) || (p_dst = (TranslocatorPart)tile.partMap(dst)).canEject()) continue;
                RenderTranslocator.renderLink(ccrs, p.side, dst, time, Vector3.fromBlockPos((BlockPos)p.pos()));
            }
            ccrs.draw();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
        }
    }

    public static void renderFluid(FluidTranslocatorPart p, Vector3 pos, float delta) {
        CCRenderState ccrs = CCRenderState.instance();
        double time = ClientUtils.getRenderTime();
        for (FluidTranslocatorPart.MovingLiquid m : p.getMovingLiquids()) {
            double start = MathHelper.interpolate((double)m.b_start, (double)m.a_start, (double)delta);
            double end = MathHelper.interpolate((double)m.b_end, (double)m.a_end, (double)delta);
            RenderTranslocator.drawLiquidSpiral(ccrs, p.side, m.dst, m.liquid, start, end, time, 0.0, pos.x, pos.y, pos.z);
            if (!p.fast) continue;
            RenderTranslocator.drawLiquidSpiral(ccrs, p.side, m.dst, m.liquid, start, end, time, 0.5, pos.x, pos.y, pos.z);
        }
    }

    public static void renderItem(ItemTranslocatorPart p, Vector3 pos, float delta) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        for (ItemTranslocatorPart.MovingItem m : p.movingItems) {
            GlStateManager.func_179094_E();
            double d = MathHelper.interpolate((double)m.b_progress, (double)m.a_progress, (double)delta);
            Vector3 path = RenderTranslocator.getPath(p.side, m.dst, d).add(RenderTranslocator.itemFloat(p.side, m.dst, d)).add(pos);
            GlStateManager.func_179137_b((double)path.x, (double)path.y, (double)path.z);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179139_a((double)0.35, (double)0.35, (double)0.35);
            renderItem.func_181564_a(m.stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    private static void renderLink(CCRenderState ccrs, int src, int dst, double time, Vector3 tPos) {
        double d = (time + (double)src + (double)(dst * 2)) % 10.0 / 6.0;
        for (int n = 0; n < 20; ++n) {
            double dn = d - (double)n * 0.1;
            int spriteX = (int)(7.0 - (double)n * 1.5 - d * 2.0);
            if (!MathHelper.between((double)0.0, (double)dn, (double)1.0) || spriteX < 0) continue;
            Vector3 pos = RenderTranslocator.getPath(src, dst, dn).add(tPos);
            double b = 1.0;
            double s = 1.0;
            double u1 = (double)spriteX / 8.0;
            double u2 = u1 + 0.125;
            double v1 = 0.0;
            double v2 = 1.0;
            RenderTranslocator.renderParticle(ccrs, pos, gradient.getColour((dn - 0.5) * 1.2 + 0.5).multiplyC(b), s * 0.12, u1, v1, u2, v2);
        }
    }

    private static void drawLiquidSpiral(CCRenderState ccrs, int src, int dst, FluidStack stack, double start, double end, double time, double theta0, double x, double y, double z) {
        RenderUtils.preFluidRender();
        TextureAtlasSprite tex = RenderUtils.prepareFluidRender((FluidStack)stack, (int)255);
        ccrs.startDrawing(7, DefaultVertexFormats.field_181709_i);
        Vector3[] last = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        Vector3[] next = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        double tess = 0.05;
        Vector3 a = RenderTranslocator.getPerp(src, dst);
        boolean rev = RenderTranslocator.sum(a.copy().crossProduct(RenderTranslocator.getPathNormal(src, dst, 0.0))) != RenderTranslocator.sum(sideVec[src]);
        for (double di = end; di <= start; di += tess) {
            Vector3 b = RenderTranslocator.getPathNormal(src, dst, di);
            Vector3 c = RenderTranslocator.getPath(src, dst, di);
            if (rev) {
                b.negate();
            }
            double r = (2.0 * di - time / 10.0 + theta0 + (double)(dst / 6)) * 2.0 * Math.PI;
            double sz = 0.1;
            Vector3 p = c.add(a.copy().multiply(MathHelper.sin((double)r) * sz)).add(b.copy().multiply(MathHelper.cos((double)r) * sz));
            double s1 = 0.02;
            double s2 = -0.02;
            next[0].set(p).add(a.x * s1 + b.x * s1, a.y * s1 + b.y * s1, a.z * s1 + b.z * s1);
            next[1].set(p).add(a.x * s2 + b.x * s1, a.y * s2 + b.y * s1, a.z * s2 + b.z * s1);
            next[2].set(p).add(a.x * s2 + b.x * s2, a.y * s2 + b.y * s2, a.z * s2 + b.z * s2);
            next[3].set(p).add(a.x * s1 + b.x * s2, a.y * s1 + b.y * s2, a.z * s1 + b.z * s2);
            if (di > end) {
                double u1 = tex.func_94214_a(Math.abs(di) * 16.0);
                double u2 = tex.func_94214_a(Math.abs(di - tess) * 16.0);
                for (int i = 0; i < 4; ++i) {
                    int j = (i + 1) % 4;
                    Vector3 axis = next[j].copy().subtract(next[i]);
                    double v1 = tex.func_94207_b(Math.abs(next[i].scalarProject(axis)) * 16.0);
                    double v2 = tex.func_94207_b(Math.abs(next[j].scalarProject(axis)) * 16.0);
                    ccrs.vert.set((Vector3)next[i], (double)u1, (double)v1).vec.add(x, y, z);
                    ccrs.writeVert();
                    ccrs.vert.set((Vector3)next[j], (double)u1, (double)v2).vec.add(x, y, z);
                    ccrs.writeVert();
                    ccrs.vert.set((Vector3)last[j], (double)u2, (double)v2).vec.add(x, y, z);
                    ccrs.writeVert();
                    ccrs.vert.set((Vector3)last[i], (double)u2, (double)v1).vec.add(x, y, z);
                    ccrs.writeVert();
                }
            }
            Vector3[] tmp = last;
            last = next;
            next = tmp;
        }
        ccrs.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderParticle(CCRenderState ccrs, Vector3 pos, Colour colour, double s, double u1, double v1, double u2, double v2) {
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        x -= Particle.field_70556_an;
        y -= Particle.field_70554_ao;
        z -= Particle.field_70555_ap;
        float par3 = ActiveRenderInfo.func_178808_b();
        float par4 = ActiveRenderInfo.func_178809_c();
        float par5 = ActiveRenderInfo.func_178803_d();
        float par6 = ActiveRenderInfo.func_178805_e();
        float par7 = ActiveRenderInfo.func_178807_f();
        BufferBuilder b = ccrs.getBuffer();
        b.func_181662_b(x - (double)par3 * s - (double)par6 * s, y - (double)par4 * s, z - (double)par5 * s - (double)par7 * s).func_187315_a(u2, v2).func_181669_b(colour.r & 0xFF, colour.g & 0xFF, colour.b & 0xFF, colour.a & 0xFF).func_181675_d();
        b.func_181662_b(x - (double)par3 * s + (double)par6 * s, y + (double)par4 * s, z - (double)par5 * s + (double)par7 * s).func_187315_a(u2, v1).func_181669_b(colour.r & 0xFF, colour.g & 0xFF, colour.b & 0xFF, colour.a & 0xFF).func_181675_d();
        b.func_181662_b(x + (double)par3 * s + (double)par6 * s, y + (double)par4 * s, z + (double)par5 * s + (double)par7 * s).func_187315_a(u1, v1).func_181669_b(colour.r & 0xFF, colour.g & 0xFF, colour.b & 0xFF, colour.a & 0xFF).func_181675_d();
        b.func_181662_b(x + (double)par3 * s - (double)par6 * s, y - (double)par4 * s, z + (double)par5 * s - (double)par7 * s).func_187315_a(u1, v2).func_181669_b(colour.r & 0xFF, colour.g & 0xFF, colour.b & 0xFF, colour.a & 0xFF).func_181675_d();
    }

    public static Vector3 getPath(int src, int dst, double d) {
        Vector3 v;
        if ((src ^ 1) == dst) {
            v = sideVec[src ^ 1].copy().multiply(d);
        } else {
            Vector3 vsrc = sideVec[src ^ 1];
            Vector3 vdst = sideVec[dst ^ 1];
            Vector3 a = vsrc.copy().multiply(0.3125);
            Vector3 b = vdst.copy().multiply(0.375);
            double sind = MathHelper.sin((double)(d * Math.PI / 2.0));
            double cosd = MathHelper.cos((double)(d * Math.PI / 2.0));
            v = a.multiply(sind).add(b.multiply(cosd - 1.0)).add(vsrc.copy().multiply(0.1875));
        }
        return v.add(sidePos[src]);
    }

    private static Vector3 getPathNormal(int srcSide, int dstSide, double d) {
        if ((srcSide ^ 1) == dstSide) {
            return sideVec[(srcSide + 4) % 6].copy();
        }
        double sind = MathHelper.sin((double)(d * Math.PI / 2.0));
        double cosd = MathHelper.cos((double)(d * Math.PI / 2.0));
        Vector3 vsrc = sideVec[srcSide ^ 1].copy();
        Vector3 vdst = sideVec[dstSide ^ 1].copy();
        return vsrc.multiply(sind).add(vdst.multiply(cosd)).normalize();
    }

    private static Vector3 itemFloat(int src, int dst, double d) {
        return RenderTranslocator.getPerp(src, dst).multiply(0.01 * MathHelper.sin((double)(d * 4.0 * Math.PI)));
    }

    public static Vector3 getPerp(int src, int dst) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 2) % 6].copy();
        }
        for (int i = 0; i < 3; ++i) {
            if (i == src / 2 || i == dst / 2) continue;
            return sideVec[i * 2].copy();
        }
        return null;
    }

    private static double sum(Vector3 v) {
        return v.x + v.y + v.z;
    }

    static {
        gradient = new CustomGradient(new ResourceLocation("translocators", "textures/fx/grad.png"));
        Map models = OBJParser.parseModels((ResourceLocation)new ResourceLocation("translocators", "models/model_new.obj"), (int)7, (Transformation)new SwapYZ());
        RenderTranslocator.plates[0] = (CCModel)models.get("Plate");
        insert = (CCModel)models.get("Insert");
        CCModel.generateSidedModels((CCModel[])plates, (int)0, (Vector3)new Vector3());
        for (int i = 0; i < 6; ++i) {
            plates[i].computeLighting(LightModel.standardLightModel);
        }
    }
}

