/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.block;

import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.tile.TileCraftingGrid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCraftingGrid
extends Block {
    ThreadLocal<BlockPos> replaceCheck = new ThreadLocal();

    public BlockCraftingGrid() {
        super(Material.field_151575_d);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCraftingGrid();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        ICuboidProvider provider = (ICuboidProvider)source.func_175625_s(pos);
        if (provider != null && !provider.getIndexedCuboids().isEmpty()) {
            return ((IndexedCuboid6)provider.getIndexedCuboids().get(0)).aabb();
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_175625_s(pos);
        if (tcraft != null) {
            for (ItemStack item : tcraft.items) {
                if (item == null) continue;
                stacks.add(item.func_77946_l());
            }
        }
        return stacks;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ICuboidProvider provider = (ICuboidProvider)worldIn.func_175625_s(pos);
        List cuboids = provider.getIndexedCuboids();
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, (List)cuboids);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_175625_s(pos);
        if (hit != null) {
            if (hit.subHit > 0) {
                tcraft.activate(hit.subHit - 1, player);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing side) {
        if (ConfigHandler.disableCraftingGrid) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (side != EnumFacing.UP && block != Blocks.field_150431_aC) {
            return false;
        }
        if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(EnumFacing.UP);
        }
        if (!world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP)) {
            return false;
        }
        if (!world.func_190527_a((Block)this, pos, false, EnumFacing.UP, null)) {
            return false;
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
        if (!world.func_175656_a(pos, this.func_176223_P())) {
            return false;
        }
        this.func_180633_a(world, pos, this.func_176223_P(), (EntityLivingBase)player, null);
        return true;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        this.replaceCheck.set(pos);
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos beneath = pos.func_177977_b();
        if (!world.isSideSolid(beneath, EnumFacing.UP, false)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack item) {
        ((TileCraftingGrid)world.func_175625_s(pos)).onPlaced(entity);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

