/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.proxy;

import codechicken.lib.vec.Cuboid6;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.item.ItemAttachment;
import cofh.thermaldynamics.render.RenderDuct;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerClient {
    public static final EventHandlerClient INSTANCE = new EventHandlerClient();

    @SubscribeEvent
    public void handleTextureStitchEventPre(TextureStitchEvent.Pre event) {
        TDTextures.registerTextures(event.getMap());
        for (int i = 0; i < TDDucts.ductList.size(); ++i) {
            if (!TDDucts.isValid(i)) continue;
            TDDucts.ductList.get(i).registerIcons(event.getMap());
        }
        TDDucts.structureInvis.registerIcons(event.getMap());
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        RenderDuct.initialize();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        float partialTicks;
        EntityPlayer player;
        RayTraceResult target = event.getTarget();
        if (this.doAttachmentHighlight(target, player = event.getPlayer(), partialTicks = event.getPartialTicks())) {
            event.setCanceled(true);
        } else if (this.doDuctHighlight(target, player, partialTicks)) {
            event.setCanceled(true);
        }
    }

    private boolean doAttachmentHighlight(RayTraceResult target, EntityPlayer player, float partialTicks) {
        if (!(ItemHelper.getHeldStack((EntityPlayer)player).func_77973_b() instanceof ItemAttachment) || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        RayTracer.retraceBlock((World)player.field_70170_p, (EntityPlayer)player, (BlockPos)target.func_178782_a());
        ItemStack stack = ItemHelper.getHeldStack((EntityPlayer)player);
        Attachment attachment = ItemAttachment.getAttachment(stack, player, player.field_70170_p, target.func_178782_a(), target.field_178784_b);
        if (attachment == null || !attachment.canAddToTile(attachment.baseTile)) {
            return false;
        }
        Cuboid6 c = attachment.getCuboid();
        c.max.subtract(c.min);
        RenderHitbox.drawSelectionBox((EntityPlayer)player, (RayTraceResult)target, (float)partialTicks, (CustomHitBox)new CustomHitBox(c.max.y, c.max.z, c.max.x, (double)attachment.baseTile.x() + c.min.x, (double)attachment.baseTile.y() + c.min.y, (double)attachment.baseTile.z() + c.min.z));
        attachment.drawSelectionExtra(player, target, partialTicks);
        return true;
    }

    private boolean doDuctHighlight(RayTraceResult target, EntityPlayer player, float partialTicks) {
        ICustomHitBox hitbox;
        if (target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        RayTracer.retraceBlock((World)player.field_70170_p, (EntityPlayer)player, (BlockPos)target.func_178782_a());
        TileEntity tile = player.field_70170_p.func_175625_s(target.func_178782_a());
        if (tile instanceof ICustomHitBox && (hitbox = (ICustomHitBox)tile).shouldRenderCustomHitBox(target.subHit, player)) {
            RenderHitbox.drawSelectionBox((EntityPlayer)player, (RayTraceResult)target, (float)partialTicks, (CustomHitBox)hitbox.getCustomHitBox(target.subHit, player));
            return true;
        }
        return false;
    }
}

