/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.sawmill;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.TileSawmill;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class SawmillRecipeWrapper
extends BaseRecipeWrapper {
    protected List<List<ItemStack>> inputs;
    protected List<ItemStack> outputs;
    protected List<FluidStack> outputFluids;
    protected int chance;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public SawmillRecipeWrapper(IGuiHelper guiHelper, SawmillManager.SawmillRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.sawmill");
    }

    public SawmillRecipeWrapper(IGuiHelper guiHelper, SawmillManager.SawmillRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        int oreID = SawmillManager.convertInput((ItemStack)recipe.getInput()).oreID;
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        recipeOutputs.add(recipe.getPrimaryOutput());
        if (recipe.getSecondaryOutput() != null) {
            recipeOutputs.add(recipe.getSecondaryOutput());
        }
        if (this.uId.equals("thermalexpansion.sawmill_tapper")) {
            FluidStack treeFluid = TapperManager.getFluid(recipe.getInput()).copy();
            recipeOutputFluids.add(treeFluid);
            this.outputFluids = recipeOutputFluids;
            this.energy = recipe.getEnergy() * 150 / 100;
        } else {
            this.outputFluids = Collections.emptyList();
            this.energy = recipe.getEnergy();
        }
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputs = recipeOutputs;
        this.chance = recipe.getSecondaryOutputChance();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(this.uId.equals("thermalexpansion.sawmill_tapper") ? 1 : 0);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(7);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        int basePower = TileSawmill.basePower;
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, Math.max(10, this.energy / basePower), IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.uId.equals("thermalexpansion.sawmill_tapper")) {
            JEIPluginTE.drawFluid(69, 23, this.outputFluids.get(0), 24, 16);
            this.fluid.draw(minecraft, 69, 23);
        }
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
        if (this.chance > 0) {
            String dispChance = StringHelper.formatNumber((long)this.chance) + "%";
            minecraft.field_71466_p.func_78276_b(dispChance, 102 - 6 * dispChance.length(), 48, 0x808080);
        }
    }
}

