/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.venus.tile.NetworkFinderSolar;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SolarModuleNetwork
implements IGridNetwork<SolarModuleNetwork, ITransmitter, TileEntity> {
    private final Set<ITransmitter> transmitters = new HashSet<ITransmitter>();

    public SolarModuleNetwork() {
    }

    public SolarModuleNetwork(Collection<SolarModuleNetwork> toMerge) {
        for (SolarModuleNetwork network : toMerge) {
            if (network == null) continue;
            for (ITransmitter transmitter : network.transmitters) {
                transmitter.setNetwork(this);
                this.transmitters.add(transmitter);
            }
            network.unregister();
        }
        this.register();
    }

    public void refreshWithChecks() {
        Iterator<ITransmitter> it = this.transmitters.iterator();
        while (it.hasNext()) {
            ITransmitter transmitter = it.next();
            if (transmitter == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)transmitter;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null || !world.func_175667_e(tile.func_174877_v())) {
                it.remove();
                continue;
            }
            if (transmitter != world.func_175625_s(tile.func_174877_v())) {
                it.remove();
                continue;
            }
            if (transmitter.getNetwork() == this) continue;
            transmitter.setNetwork(this);
            transmitter.onNetworkChanged();
        }
    }

    @Override
    public void refresh() {
        Iterator<ITransmitter> it = this.transmitters.iterator();
        while (it.hasNext()) {
            ITransmitter conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null) {
                it.remove();
                continue;
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
    }

    @Override
    public SolarModuleNetwork merge(SolarModuleNetwork network) {
        if (network != null && network != this) {
            SolarModuleNetwork newNetwork = new SolarModuleNetwork(Lists.newArrayList((Object[])new SolarModuleNetwork[]{this, network}));
            newNetwork.refresh();
            return newNetwork;
        }
        return this;
    }

    private void destroy() {
        this.transmitters.clear();
    }

    @Override
    public void split(ITransmitter splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getTransmitters().remove(splitPoint);
            splitPoint.setNetwork(null);
            if (this.getTransmitters().size() > 1) {
                World world = ((TileEntity)splitPoint).func_145831_w();
                if (this.getTransmitters().size() > 0) {
                    ITransmitter[] nextToSplit = new ITransmitter[6];
                    boolean[] toDo = new boolean[]{true, true, true, true, true, true};
                    for (int j = 0; j < 6; ++j) {
                        TileEntity tileEntity;
                        switch (j) {
                            case 0: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177977_b());
                                break;
                            }
                            case 1: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177984_a());
                                break;
                            }
                            case 2: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177978_c());
                                break;
                            }
                            case 3: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177968_d());
                                break;
                            }
                            case 4: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177976_e());
                                break;
                            }
                            case 5: {
                                tileEntity = world.func_175625_s(((TileEntity)splitPoint).func_174877_v().func_177974_f());
                                break;
                            }
                            default: {
                                tileEntity = null;
                            }
                        }
                        if (tileEntity instanceof ITransmitter) {
                            nextToSplit[j] = (ITransmitter)tileEntity;
                            continue;
                        }
                        toDo[j] = false;
                    }
                    for (int i1 = 0; i1 < 6; ++i1) {
                        if (!toDo[i1]) continue;
                        ITransmitter connectedBlockA = nextToSplit[i1];
                        NetworkFinderSolar finder = new NetworkFinderSolar(world, new BlockVec3((TileEntity)connectedBlockA), new BlockVec3((TileEntity)splitPoint));
                        List<ITransmitter> partNetwork = finder.exploreNetwork();
                        for (int i2 = i1 + 1; i2 < 6; ++i2) {
                            ITransmitter connectedBlockB = nextToSplit[i2];
                            if (!toDo[i2] || !partNetwork.contains(connectedBlockB)) continue;
                            toDo[i2] = false;
                        }
                        SolarModuleNetwork newNetwork = new SolarModuleNetwork();
                        newNetwork.getTransmitters().addAll(partNetwork);
                        newNetwork.refreshWithChecks();
                        newNetwork.register();
                    }
                    this.destroy();
                }
            } else if (this.getTransmitters().size() == 0) {
                this.destroy();
            }
        }
        if (this.transmitters.isEmpty()) {
            this.unregister();
        }
    }

    public void register() {
        GalacticraftPlanets.proxy.registerNetwork(this);
    }

    public void unregister() {
        GalacticraftPlanets.proxy.unregisterNetwork(this);
    }

    public void addTransmitter(ITransmitter transmitter) {
        this.transmitters.add(transmitter);
        this.refresh();
    }

    public void removeTransmitter(ITransmitter transmitter) {
        this.transmitters.remove(transmitter);
    }

    @Override
    public Set<ITransmitter> getTransmitters() {
        return this.transmitters;
    }

    public String toString() {
        return "SolarModuleNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "]";
    }
}

