/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerSolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiSolarArrayController
extends GuiContainerGC {
    private static final ResourceLocation solarGuiTexture = new ResourceLocation("galacticraftplanets", "textures/gui/solar_array_controller.png");
    private final TileEntitySolarArrayController solarController;
    private GuiButton buttonEnableSolar;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiSolarArrayController(InventoryPlayer par1InventoryPlayer, TileEntitySolarArrayController solarController) {
        super(new ContainerSolarArrayController(par1InventoryPlayer, solarController));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 107, (this.field_146295_m - this.field_147000_g) / 2 + 101, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.solarController = solarController;
        this.field_147000_g = 209;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.solarController.func_174877_v(), 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energy_storage.desc.0"));
        electricityDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.energy_storage.desc.1") + (int)Math.floor(this.solarController.getEnergyStoredGC()) + " / " + (int)Math.floor(this.solarController.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 96;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 151, (this.field_146295_m - this.field_147000_g) / 2 + 90, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> sunGenDesc = new ArrayList<String>();
        float sunVisible = (float)Math.round((float)this.solarController.getActualArraySize() / (float)this.solarController.getPossibleArraySize() * 1000.0f) / 10.0f;
        sunGenDesc.add(sunVisible > 0.0f ? GCCoreUtil.translate("gui.status.sun_visible.name") + ": " + sunVisible + "%" : GCCoreUtil.translate("gui.status.blockedfully.name"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 47, (this.field_146295_m - this.field_147000_g) / 2 + 20, 18, 18, sunGenDesc, this.field_146294_l, this.field_146295_m, this));
        this.buttonEnableSolar = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 11, 72, 20, GCCoreUtil.translate("gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnableSolar);
    }

    protected void func_146979_b(int par1, int par2) {
        int offsetY = 35;
        this.buttonEnableSolar.field_146124_l = this.solarController.disableCooldown == 0;
        this.buttonEnableSolar.field_146126_j = !this.solarController.getDisabled(0) ? GCCoreUtil.translate("gui.button.disable.name") : GCCoreUtil.translate("gui.button.enable.name");
        String displayString = this.solarController.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = GCCoreUtil.translate("gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate("gui.message.generating.name") + ": " + (this.solarController.generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS(this.solarController.generateWatts) + "/t" : GCCoreUtil.translate("gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        float boost = (float)Math.round((this.solarController.getSolarBoost() - 1.0f) * 1000.0f) / 10.0f;
        displayString = GCCoreUtil.translate("gui.message.environment.name") + ": " + boost + "%";
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 33 + offsetY, 0x404040);
        displayString = GCCoreUtil.translateWithFormat("gui.message.connected_solar_controller.name", this.solarController.getActualArraySize());
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 44 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    private String getStatus() {
        if (this.solarController.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.disabled.name");
        }
        if (!this.solarController.func_145831_w().func_72935_r()) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.blockedfully.name");
        }
        if (this.solarController.func_145831_w().func_72896_J() || this.solarController.func_145831_w().func_72911_I()) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.raining.name");
        }
        float sunVisible = (float)Math.floor((float)this.solarController.getActualArraySize() / (float)this.solarController.getPossibleArraySize());
        if (sunVisible == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.blockedfully.name");
        }
        if (sunVisible < 1.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.blockedpartial.name");
        }
        if (this.solarController.generateWatts > 0) {
            return (Object)((Object)EnumColor.DARK_GREEN) + GCCoreUtil.translate("gui.status.collectingenergy.name");
        }
        return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.unknown.name");
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        float sunVisible;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(solarGuiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        EnergyDisplayHelper.getEnergyDisplayTooltip(this.solarController.getEnergyStoredGC(), this.solarController.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.solarController.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(var5 + 83, var6 + 24, 176, 0, 11, 10);
        }
        if ((sunVisible = (float)Math.floor((float)this.solarController.getActualArraySize() / (float)this.solarController.getPossibleArraySize())) > 0.0f) {
            this.func_73729_b(var5 + 48, var6 + 21, 176, 10, 16, 16);
        }
        this.func_73729_b(var5 + 97, var6 + 25, 187, 0, Math.min(this.solarController.getScaledElecticalLevel(54), 54), 7);
    }
}

