/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GuiTerraformer
extends GuiContainerGC
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation terraformerGui = new ResourceLocation("galacticraftplanets", "textures/gui/terraformer.png");
    private TileEntityTerraformer terraformer;
    private GuiButton enableTreesButton;
    private GuiButton enableGrassButton;
    private GuiElementCheckbox checkboxRenderBubble;
    private GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion(0, 0, 52, 9, null, 0, 0, this);
    private GuiElementInfoRegion waterTankInfoRegion = new GuiElementInfoRegion(0, 0, 41, 28, null, 0, 0, this);

    public GuiTerraformer(InventoryPlayer par1InventoryPlayer, TileEntityTerraformer terraformer) {
        super(new ContainerTerraformer(par1InventoryPlayer, terraformer, (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g));
        this.field_147000_g = 237;
        this.terraformer = terraformer;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        if (this.terraformer.disableCooldown > 0) {
            this.enableTreesButton.field_146124_l = false;
            this.enableGrassButton.field_146124_l = false;
        } else {
            this.enableTreesButton.field_146124_l = true;
            this.enableGrassButton.field_146124_l = true;
        }
        this.enableTreesButton.field_146126_j = GCCoreUtil.translate(this.terraformer.treesDisabled ? "gui.button.enable.name" : "gui.button.disable.name") + " " + GCCoreUtil.translate("gui.message.trees.name");
        this.enableGrassButton.field_146126_j = GCCoreUtil.translate(this.terraformer.grassDisabled ? "gui.button.enable.name" : "gui.button.disable.name") + " " + GCCoreUtil.translate("gui.message.grass.name");
        super.func_73863_a(par1, par2, par3);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.electricInfoRegion.tooltipStrings = new ArrayList<String>();
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 44;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 47;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 24, (this.field_146295_m - this.field_147000_g) / 2 + 38, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        batterySlotDesc = new ArrayList();
        batterySlotDesc.add(GCCoreUtil.translate("gui.show_bubble.desc.0"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 85, (this.field_146295_m - this.field_147000_g) / 2 + 132, 85, 13, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        this.waterTankInfoRegion.tooltipStrings = new ArrayList<String>();
        this.waterTankInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 55;
        this.waterTankInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 17;
        this.waterTankInfoRegion.parentWidth = this.field_146294_l;
        this.waterTankInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.waterTankInfoRegion);
        this.field_146292_n.clear();
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.enableTreesButton = new GuiButton(0, var5 + 98, var6 + 85, 72, 20, GCCoreUtil.translate("gui.message.enable_trees.name"));
        this.enableGrassButton = new GuiButton(1, var5 + 98, var6 + 109, 72, 20, GCCoreUtil.translate("gui.message.enable_grass.name"));
        this.field_146292_n.add(this.enableTreesButton);
        this.field_146292_n.add(this.enableGrassButton);
        this.checkboxRenderBubble = new GuiElementCheckbox(2, this, var5 + 85, var6 + 132, GCCoreUtil.translate("gui.message.bubble_visible.name"));
        this.field_146292_n.add(this.checkboxRenderBubble);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                case 0: {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.terraformer.func_174877_v(), 0}));
                    break;
                }
                case 1: {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.terraformer.func_174877_v(), 1}));
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    protected void func_146979_b(int par1, int par2) {
        String displayString = this.terraformer.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 5, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 8, 144, 0x404040);
        this.field_146289_q.func_78279_b(this.getStatus(), 105, 24, this.field_146999_f - 105, 0x404040);
    }

    private String getStatus() {
        if (RedstoneUtil.isBlockReceivingRedstone(this.terraformer.func_145831_w(), this.terraformer.func_174877_v())) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.status.off.name");
        }
        if (this.terraformer.getEnergyStoredGC() <= 0.0f) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.no_energy.name");
        }
        if (this.terraformer.grassDisabled && this.terraformer.treesDisabled) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.disabled.name");
        }
        if (this.terraformer.waterTank.getFluid() == null || this.terraformer.waterTank.getFluid().amount <= 0) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.no_water.name");
        }
        if (this.terraformer.getFirstBonemealStack().func_190926_b()) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.no_bonemeal.name");
        }
        if (!this.terraformer.grassDisabled && this.terraformer.getFirstSeedStack().func_190926_b()) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.no_seeds.name");
        }
        if (!this.terraformer.treesDisabled && this.terraformer.getFirstSaplingStack().func_190926_b()) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.no_saplings.name");
        }
        if ((double)this.terraformer.getBubbleSize() < this.terraformer.MAX_SIZE - 0.5) {
            return (Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.message.bubble_exp.name");
        }
        if (!this.terraformer.treesDisabled && this.terraformer.grassBlocksListSize <= 0) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.trees.name") + ": " + GCCoreUtil.translate("gui.message.no_valid_blocks.name");
        }
        if (!this.terraformer.grassDisabled && this.terraformer.terraformableBlocksListSize <= 0) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.grass.name") + ": " + GCCoreUtil.translate("gui.message.no_valid_blocks.name");
        }
        return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.message.terraforming.name");
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(terraformerGui);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scale = this.terraformer.getScaledElecticalLevel(54);
        this.func_73729_b(var5 + 45, var6 + 48, 176, 26, Math.min(scale, 54), 7);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip(this.terraformer.getEnergyStoredGC(), this.terraformer.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        int waterLevel = this.terraformer.getScaledWaterLevel(100);
        ArrayList<String> processDesc = new ArrayList<String>();
        processDesc.clear();
        processDesc.add(GCCoreUtil.translate("gui.terraformer.desc.0") + ": " + waterLevel + "%");
        this.waterTankInfoRegion.tooltipStrings = processDesc;
        waterLevel = this.terraformer.getScaledWaterLevel(26);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 56, (this.field_146295_m - this.field_147000_g) / 2 + 17 + 27 - waterLevel, 176, 26 - waterLevel, 39, waterLevel);
        this.checkboxRenderBubble.isSelected = this.terraformer.shouldRenderBubble;
    }

    @Override
    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.terraformer.shouldRenderBubble = newSelected;
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{6, this.terraformer.func_174877_v(), newSelected ? 1 : 0}));
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return this.terraformer.shouldRenderBubble;
    }

    @Override
    public void onIntruderInteraction() {
    }
}

