/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.client.FluidTexturesGC;
import micdoodle8.mods.galacticraft.planets.asteroids.client.fx.EntityFXTeleport;
import micdoodle8.mods.galacticraft.planets.asteroids.client.gui.GuiAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.client.gui.GuiShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderSmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelRocketT3;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityBeamReceiverRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityBeamReflectorRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityMinerBaseRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityShortRangeTelepadRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandlerClient;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.mars.client.fx.EntityCryoFX;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AsteroidsModuleClient
implements IPlanetsModuleClient {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySmallAsteroid.class, manager -> new RenderSmallAsteroid(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityGrapple.class, manager -> new RenderGrapple(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityEntryPod.class, manager -> new RenderEntryPod(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier3Rocket.class, manager -> new RenderTier3Rocket(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityAstroMiner.class, manager -> new RenderAstroMiner(manager));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void registerVariants() {
        this.addPlanetVariants("asteroids_block", "asteroids_block", "asteroid_rock_1", "asteroid_rock_2", "ore_aluminum_asteroids", "ore_ilmenite_asteroids", "ore_iron_asteroids", "asteroid_deco", "titanium_block");
        this.addPlanetVariants("thermal_padding", "thermal_padding", "thermal_chestplate", "thermal_leggings", "thermal_boots");
        this.addPlanetVariants("item_basic_asteroids", "item_basic_asteroids", "engine_t2", "rocket_fins_t2", "shard_iron", "shard_titanium", "ingot_titanium", "compressed_titanium", "thermal_cloth", "beam_core", "dust_titanium");
        this.addPlanetVariants("walkway", "walkway", "walkway_wire", "walkway_pipe");
        this.addPlanetVariants("strange_seed", "strange_seed", "strange_seed1");
        Item receiver = Item.func_150898_a((Block)AsteroidBlocks.beamReceiver);
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("galacticraftplanets:beam_receiver", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)receiver, (int)0, (ModelResourceLocation)modelResourceLocation);
        Item reflector = Item.func_150898_a((Block)AsteroidBlocks.beamReflector);
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:beam_reflector", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)reflector, (int)0, (ModelResourceLocation)modelResourceLocation);
        Item teleporter = Item.func_150898_a((Block)AsteroidBlocks.shortRangeTelepad);
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:telepad_short", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)teleporter, (int)0, (ModelResourceLocation)modelResourceLocation);
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:grapple", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)AsteroidsItems.grapple, (int)0, (ModelResourceLocation)modelResourceLocation);
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:rocket_t3", "inventory");
        for (int i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)AsteroidsItems.tier3Rocket, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:astro_miner", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)AsteroidsItems.astroMiner, (int)0, (ModelResourceLocation)modelResourceLocation);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.replaceModelDefault(event, "beam_receiver", "block/receiver.obj", (List<String>)ImmutableList.of((Object)"Main", (Object)"Receiver", (Object)"Ring"), ItemModelBeamReceiver.class, (IModelState)TRSRTransformation.identity(), "inventory", "facing=up", "facing=down", "facing=north", "facing=west", "facing=east", "facing=south");
        this.replaceModelDefault(event, "beam_reflector", "block/reflector.obj", (List<String>)ImmutableList.of((Object)"Base", (Object)"Axle", (Object)"EnergyBlaster", (Object)"Ring"), ItemModelBeamReflector.class, (IModelState)TRSRTransformation.identity(), "inventory", "normal");
        this.replaceModelDefault(event, "telepad_short", "block/telepad_short.obj", (List<String>)ImmutableList.of((Object)"Top", (Object)"Bottom", (Object)"Connector"), ItemModelTelepad.class, (IModelState)TRSRTransformation.identity(), "inventory", "normal");
        this.replaceModelDefault(event, "grapple", "grapple.obj", (List<String>)ImmutableList.of((Object)"Grapple"), ItemModelGrapple.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "rocket_t3", "tier3rocket.obj", (List<String>)ImmutableList.of((Object)"Boosters", (Object)"Cube", (Object)"NoseCone", (Object)"Rocket"), ItemModelRocketT3.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "astro_miner", "astro_miner_inv.obj", (List<String>)ImmutableList.of((Object)"Hull_Center"), ItemModelAstroMiner.class, (IModelState)TRSRTransformation.identity(), new String[0]);
    }

    private void replaceModelDefault(ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtil.replaceModel("galacticraftplanets", event, resLoc, objLoc, visibleGroups, clazz, parentState, variants);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(event, "minerbase");
        this.registerTexture(event, "beam_reflector");
        this.registerTexture(event, "beam_receiver");
        this.registerTexture(event, "telepad_short");
        this.registerTexture(event, "telepad_short0");
        this.registerTexture(event, "grapple");
        this.registerTexture(event, "tier3rocket");
        this.registerTexture(event, "astro_miner");
        this.registerTexture(event, "astro_miner_off");
        this.registerTexture(event, "astro_miner_fx");
        this.registerTexture(event, "space_pod");
        this.registerTexture(event, "fluids/argon");
        this.registerTexture(event, "fluids/atmosphericgases");
        this.registerTexture(event, "fluids/carbondioxide");
        this.registerTexture(event, "fluids/helium");
        this.registerTexture(event, "fluids/liquidargon");
        this.registerTexture(event, "fluids/liquidmethane");
        this.registerTexture(event, "fluids/liquidnitrogen");
        this.registerTexture(event, "fluids/liquidoxygen");
        this.registerTexture(event, "fluids/methane");
        this.registerTexture(event, "fluids/nitrogen");
    }

    private void registerTexture(TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation("galacticraftplanets:blocks/" + texture));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        AsteroidsEventHandlerClient clientEventHandler = new AsteroidsEventHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
        FluidTexturesGC.init();
        AsteroidsModuleClient.registerBlockRenderers();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeamReflector.class, (TileEntitySpecialRenderer)new TileEntityBeamReflectorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeamReceiver.class, (TileEntitySpecialRenderer)new TileEntityBeamReceiverRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMinerBase.class, (TileEntitySpecialRenderer)new TileEntityMinerBaseRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityShortRangeTelepad.class, (TileEntitySpecialRenderer)new TileEntityShortRangeTelepadRenderer());
    }

    public static void registerBlockRenderers() {
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 0, "asteroids_block");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 1, "asteroid_rock_1");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 2, "asteroid_rock_2");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 3, "ore_aluminum_asteroids");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 4, "ore_ilmenite_asteroids");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 5, "ore_iron_asteroids");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 6, "asteroid_deco");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockBasic, 7, "titanium_block");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockWalkway, 0, "walkway");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockWalkway, 1, "walkway_wire");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockWalkway, 2, "walkway_pipe");
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockDenseIce);
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.blockMinerBase);
        ClientUtil.registerBlockJson("galacticraftplanets:", AsteroidBlocks.minerBaseFull);
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.thermalPadding, 0, "thermal_padding");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.thermalPadding, 1, "thermal_chestplate");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.thermalPadding, 2, "thermal_leggings");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.thermalPadding, 3, "thermal_boots");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 5, "item_basic_asteroids");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 1, "engine_t2");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 2, "rocket_fins_t2");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 3, "shard_iron");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 4, "shard_titanium");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 0, "ingot_titanium");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 6, "compressed_titanium");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 7, "thermal_cloth");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 8, "beam_core");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.basicItem, 9, "dust_titanium");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.heavyNoseCone, 0, "heavy_nose_cone");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.strangeSeed, 0, "strange_seed");
        ClientUtil.registerItemJson("galacticraftplanets:", AsteroidsItems.strangeSeed, 1, "strange_seed1");
    }

    private void addPlanetVariants(String name, String ... variants) {
        Item itemBlockVariants = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("galacticraftplanets", name));
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation("galacticraftplanets:" + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        switch (ID) {
            case 3: {
                if (tile instanceof TileEntityShortRangeTelepad) {
                    return new GuiShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile);
                }
                if (!(tile instanceof TileEntityMinerBase)) break;
                return new GuiAstroMinerDock(player.field_71071_by, (TileEntityMinerBase)tile);
            }
        }
        return null;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.func_175606_aa() != null && mc.field_71452_i != null) {
            double dX = mc.func_175606_aa().field_70165_t - position.x;
            double dY = mc.func_175606_aa().field_70163_u - position.y;
            double dZ = mc.func_175606_aa().field_70161_v - position.z;
            Particle particle = null;
            double viewDistance = 64.0;
            if (dX * dX + dY * dY + dZ * dZ < viewDistance * viewDistance) {
                if (particleID.equals("portalBlue")) {
                    particle = new EntityFXTeleport((World)mc.field_71441_e, position, motion, (TileEntityShortRangeTelepad)extraData[0], (Boolean)extraData[1]);
                } else if (particleID.equals("cryoFreeze")) {
                    particle = new EntityCryoFX((World)mc.field_71441_e, position, motion);
                }
            }
            if (particle != null) {
                mc.field_71452_i.func_78873_a(particle);
            }
        }
    }
}

